// Released under the terms of the BSD License
// (C) 2016, Analog Devices, Inc.

/// @file version.hpp
/// @brief Library versioning support.
/// Versioning for libsmu follows the guidelines of semantic versioning for
/// shared libraries (http://semver.org/).

#pragma once

/// @brief The major version of the libsmu library (X.0.0).
#define LIBSMU_VERSION_MAJOR 1

/// @brief The minor version of the libsmu library (0.X.0).
#define LIBSMU_VERSION_MINOR 0

/// @brief The patch version of the libsmu library (0.0.X).
#define LIBSMU_VERSION_PATCH 3

/// @brief A numerical libsmu library version.
#define LIBSMU_VERSION ((LIBSMU_VERSION_MAJOR << 16) |\
			(LIBSMU_VERSION_MINOR << 8) |\
			LIBSMU_VERSION_PATCH)

/// @brief A string representing the libsmu library version.
#define LIBSMU_VERSION_STR "1.0.3"

/// @private
inline const char* libsmu_version_str() {
	    return LIBSMU_VERSION_STR;
}

/// @private
inline uint32_t libsmu_version_major() {
	    return LIBSMU_VERSION_MAJOR;
}

/// @private
inline uint32_t libsmu_version_minor() {
	    return LIBSMU_VERSION_MINOR;
}

/// @private
inline uint32_t libsmu_version_patch() {
	    return LIBSMU_VERSION_PATCH;
}
