#-----------------------------------------------------------------------------
#
# SimpleITKConfig.cmake - SimpleITK CMake configuration file for external
# projects.
#
# This file is configured by SimpleITK, imported into client projects by
# find_package(SimpleITK), and provides values for UseSimpleITK.cmake.

# This SimpleITKConfig file is configured for the install tree

# Compute this installation's prefix from this file's location:
get_filename_component(_SimpleITKConfig_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)
set(SimpleITK_INSTALL_PREFIX "${_SimpleITKConfig_DIR}")
get_filename_component(SimpleITK_INSTALL_PREFIX "${SimpleITK_INSTALL_PREFIX}" PATH)
get_filename_component(SimpleITK_INSTALL_PREFIX "${SimpleITK_INSTALL_PREFIX}" PATH)
get_filename_component(SimpleITK_INSTALL_PREFIX "${SimpleITK_INSTALL_PREFIX}" PATH)


# The SimpleITK version number
#
# If version component is unset it the SimpleITK project it will
# remain unset for project who use it, this changes the default CMake
# behavior of setting unset version values to 0.
set(SimpleITK_VERSION_MAJOR "1")
set(SimpleITK_VERSION_MINOR "2")
set(SimpleITK_VERSION_PATCH)
if(NOT "3" STREQUAL "")
  set(SimpleITK_VERSION_PATCH "3")
endif()
set(SimpleITK_VERSION_TWEAK)
if(NOT "" STREQUAL "")
  set(SimpleITK_VERSION_TWEAK  "")
endif()
set(SimpleITK_VERSION_RC)
if(NOT "" STREQUAL "")
  set(SimpleITK_VERSION_RC "")
endif()
set(SimpleITK_VERSION_POST)
if(NOT "" STREQUAL "")
  set(SimpleITK_VERSION_POST "")
endif()
set(SimpleITK_VERSION_DEV)
if(NOT "" STREQUAL "")
  set(SimpleITK_VERSION_DEV "")
endif()
set(SimpleITK_VERSION_HASH)
if(NOT "SimpleITK_VERSION_HASH@" STREQUAL "")
  set(SimpleITK_VERSION_HASH "b9a08")
endif()
set(SimpleITK_VERSION_COUNT)




# The SimpleITK include file directories.
set(SimpleITK_INCLUDE_DIRS "${SimpleITK_INSTALL_PREFIX}/include/SimpleITK-1.2")

# The SimpleITK library directories.
set(ITK_LIBRARY_DIRS "C:/bld/libitk_1569252808710/_h_env/Library/lib")
set(SimpleITK_LIBRARY_DIRS "${ITK_LIBRARY_DIRS}")

# The location of the UseITK.cmake file.
set(SimpleITK_USE_FILE "${_SimpleITKConfig_DIR}/UseSimpleITK.cmake")

# Locate ITK for required targets
if(NOT ITK_CONFIG_TARGETS_FILE)
  find_package(ITK "4.13.2" EXACT REQUIRED)
endif()

# Import SimpleITK targets.
set(SimpleITK_TARGETS_FILE "${_SimpleITKConfig_DIR}/SimpleITKTargets.cmake")
if(NOT SimpleITK_TARGETS_IMPORTED)
  set(SimpleITK_TARGETS_IMPORTED 1)
  include("${SimpleITK_TARGETS_FILE}")
endif()

# A list of all libraries for SimpleITK.  Those listed here should
# automatically pull in their dependencies via imported targets.
set(SimpleITK_LIBRARIES "SimpleITKCommon;SimpleITKIO;SimpleITKRegistration;SimpleITKBasicFilters0;SimpleITK_AnisotropicDiffusionLBR;SimpleITK_ITKAnisotropicSmoothing;SimpleITK_ITKAntiAlias;SimpleITK_ITKBiasCorrection;SimpleITK_ITKBinaryMathematicalMorphology;SimpleITK_ITKClassifiers;SimpleITK_ITKColormap;SimpleITK_ITKCommon;SimpleITK_ITKConnectedComponents;SimpleITK_ITKConvolution;SimpleITK_ITKCurvatureFlow;SimpleITK_ITKDeconvolution;SimpleITK_ITKDenoising;SimpleITK_ITKDisplacementField;SimpleITK_ITKDistanceMap;SimpleITK_ITKFFT;SimpleITK_ITKFastMarching;SimpleITK_ITKImageCompare;SimpleITK_ITKImageCompose;SimpleITK_ITKImageFeature;SimpleITK_ITKImageFilterBase;SimpleITK_ITKImageFunction;SimpleITK_ITKImageFusion;SimpleITK_ITKImageGradient;SimpleITK_ITKImageGrid;SimpleITK_ITKImageIntensity;SimpleITK_ITKImageLabel;SimpleITK_ITKImageNoise;SimpleITK_ITKImageSources;SimpleITK_ITKImageStatistics;SimpleITK_ITKLabelMap;SimpleITK_ITKLabelVoting;SimpleITK_ITKLevelSets;SimpleITK_ITKMathematicalMorphology;SimpleITK_ITKPDEDeformableRegistration;SimpleITK_ITKRegionGrowing;SimpleITK_ITKRegistrationCommon;SimpleITK_ITKReview;SimpleITK_ITKSmoothing;SimpleITK_ITKThresholding;SimpleITK_ITKTransform;SimpleITK_ITKWatersheds;SimpleITK_LabelErodeDilate;SimpleITK_SimpleITKFilters;SimpleITKBasicFilters1")
