/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkWienerDeconvolutionImageFilter_h
#define sitkWienerDeconvolutionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class WienerDeconvolutionImageFilter
\brief The Wiener deconvolution image filter is designed to restore an image convolved with a blurring kernel while keeping noise enhancement to a minimum.

The Wiener filter aims to minimize noise enhancement induced by frequencies with low signal-to-noise ratio. The Wiener filter kernel is defined in the frequency domain as \f$W(\omega) = H^*(\omega) / (|H(\omega)|^2 + (1 / SNR(\omega)))\f$ where \f$H(\omega)\f$ is the Fourier transform of the blurring kernel with which the original image was convolved and the signal-to-noise ratio \f$SNR(\omega)\f$ . \f$SNR(\omega)\f$ is defined by \f$P_f(\omega) / P_n(\omega)\f$ where \f$P_f(\omega)\f$ is the power spectral density of the uncorrupted signal and \f$P_n(\omega)\f$ is the power spectral density of the noise. When applied to the input blurred image, this filter produces an estimate \f$\hat{f}(x)\f$ of the true underlying signal \f$f(x)\f$ that minimizes the expected error between \f$\hat{f}(x)\f$ and \f$f(x)\f$ .

This filter requires two inputs, the image to be deconvolved and the blurring kernel. These two inputs can be set using the methods SetInput() and SetKernelImage() , respectively.

The power spectral densities of the signal and noise are typically unavailable for a given problem. In particular, \f$P_f(\omega)\f$ cannot be computed from \f$f(x)\f$ because this unknown signal is precisely the signal that this filter aims to recover. Nevertheless, it is common for the noise to have a power spectral density that is flat or decreasing significantly more slowly than the power spectral density of a typical image as the frequency \f$\omega\f$ increases. Hence, \f$P_n(\omega)\f$ can typically be approximated with a constant, and this filter makes this assumption (see the NoiseVariance member variable). \f$P_f(\omega)\f$ , on the other hand, will vary with input. This filter computes the power spectral density of the input blurred image, subtracts the power spectral density of the noise, and uses the result as the estimate of \f$P_f(\omega)\f$ .

For further information on the Wiener deconvolution filter, please see "Digital Signal Processing" by Kenneth R. Castleman, Prentice Hall, 1995

\author Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France 

\author Chris Mullins, The University of North Carolina at Chapel Hill 

\author Cory Quammen, The University of North Carolina at Chapel Hill
\sa itk::simple::WienerDeconvolution for the procedural interface
\sa itk::WienerDeconvolutionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT WienerDeconvolutionImageFilter : public ImageFilter<2> {
    public:
      typedef WienerDeconvolutionImageFilter Self;

      /** Destructor */
      virtual ~WienerDeconvolutionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      WienerDeconvolutionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/get the variance of the zero-mean Gaussian white noise assumed to be added to the input.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNoiseVariance ( double NoiseVariance ) { this->m_NoiseVariance = NoiseVariance; return *this; }

      /**
       * Set/get the variance of the zero-mean Gaussian white noise assumed to be added to the input.
       */
        double GetNoiseVariance() const { return this->m_NoiseVariance; }

      /**
       * Normalize the output image by the sum of the kernel components

       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalize ( bool Normalize ) { this->m_Normalize = Normalize; return *this; }

      /** Set the value of Normalize to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOn() { return this->SetNormalize(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOff() { return this->SetNormalize(false); }

      /**
       */
        bool GetNormalize() const { return this->m_Normalize; }

      typedef enum {ZERO_PAD,ZERO_FLUX_NEUMANN_PAD,PERIODIC_PAD} BoundaryConditionType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBoundaryCondition ( BoundaryConditionType BoundaryCondition ) { this->m_BoundaryCondition = BoundaryCondition; return *this; }

      /**
       */
        BoundaryConditionType GetBoundaryCondition() const { return this->m_BoundaryCondition; }

      typedef enum {SAME,VALID} OutputRegionModeType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputRegionMode ( OutputRegionModeType OutputRegionMode ) { this->m_OutputRegionMode = OutputRegionMode; return *this; }

      /**
       */
        OutputRegionModeType GetOutputRegionMode() const { return this->m_OutputRegionMode; }
      /** Name of this class */
      std::string GetName() const { return std::string ("WienerDeconvolutionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter on the input images with the given parameters */
      Image Execute ( const Image& image1, const Image& image2, double noiseVariance, bool normalize, WienerDeconvolutionImageFilter::BoundaryConditionType boundaryCondition, WienerDeconvolutionImageFilter::OutputRegionModeType outputRegionMode );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_NoiseVariance;
      /*  */
      bool  m_Normalize;
      BoundaryConditionType  m_BoundaryCondition;
      OutputRegionModeType  m_OutputRegionMode;
    };


    /**
     * \brief The Wiener deconvolution image filter is designed to restore an image convolved with a blurring kernel while keeping noise enhancement to a minimum.
     *
     * This function directly calls the execute method of WienerDeconvolutionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::WienerDeconvolutionImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image WienerDeconvolution ( const Image& image1, const Image& image2, double noiseVariance = 0.0, bool normalize = false, WienerDeconvolutionImageFilter::BoundaryConditionType boundaryCondition = itk::simple::WienerDeconvolutionImageFilter::ZERO_FLUX_NEUMANN_PAD, WienerDeconvolutionImageFilter::OutputRegionModeType outputRegionMode = itk::simple::WienerDeconvolutionImageFilter::SAME );

  }
}
#endif
