/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkVotingBinaryIterativeHoleFillingImageFilter_h
#define sitkVotingBinaryIterativeHoleFillingImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class VotingBinaryIterativeHoleFillingImageFilter
\brief Fills in holes and cavities by iteratively applying a voting operation.

This filter uses internally the VotingBinaryHoleFillingImageFilter , and runs it iteratively until no pixels are being changed or until it reaches the maximum number of iterations. The purpose of the filter is to fill in holes of medium size (tens of pixels in radius). In principle the number of iterations is related to the size of the holes to be filled in. The larger the holes, the more iteration must be run with this filter in order to fill in the full hole. The size of the neighborhood is also related to the curvature of the hole borders and therefore the hole size. Note that as a collateral effect this filter may also fill in cavities in the external side of structures.

This filter is templated over a single image type because the output image type must be the same as the input image type. This is required in order to make the iterations possible, since the output image of one iteration is taken as the input image for the next iteration.

\see Image 

\see VotingBinaryImageFilter 

\see VotingBinaryHoleFillingImageFilter 

\see Neighborhood 

\see NeighborhoodOperator 

\see NeighborhoodIterator
\sa itk::simple::VotingBinaryIterativeHoleFilling for the procedural interface
\sa itk::VotingBinaryIterativeHoleFillingImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT VotingBinaryIterativeHoleFillingImageFilter : public ImageFilter<1> {
    public:
      typedef VotingBinaryIterativeHoleFillingImageFilter Self;

      /** Destructor */
      virtual ~VotingBinaryIterativeHoleFillingImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      VotingBinaryIterativeHoleFillingImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;



      /**
       * Set the radius of the neighborhood used to compute the median.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius ( const std::vector<unsigned int> & Radius ) { this->m_Radius = Radius; return *this; }

      /** Set the values of the Radius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius( unsigned int value ) { this->m_Radius = std::vector<unsigned int>(3, value); return *this; }


      /**
       * Get the radius of the neighborhood used to compute the median
       */
        std::vector<unsigned int> GetRadius() const { return this->m_Radius; }

      /**
       * Maximum number of iterations. This filter is executed iteratively as long as at least one pixel has changed in a previous iteration, or until the maximum number of iterations has been reached.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaximumNumberOfIterations ( unsigned int MaximumNumberOfIterations ) { this->m_MaximumNumberOfIterations = MaximumNumberOfIterations; return *this; }

      /**
       * Maximum number of iterations. This filter is executed iteratively as long as at least one pixel has changed in a previous iteration, or until the maximum number of iterations has been reached.
       */
        unsigned int GetMaximumNumberOfIterations() const { return this->m_MaximumNumberOfIterations; }

      /**
       * Majority threshold. It is the number of pixels over 50% that will decide whether an OFF pixel will become ON or not. For example, if the neighborhood of a pixel has 124 pixels (excluding itself), the 50% will be 62, and if you set upd a Majority threshold of 5, that means that the filter will require 67 or more neighbor pixels to be ON in order to switch the current OFF pixel to ON. The default value is 1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMajorityThreshold ( unsigned int MajorityThreshold ) { this->m_MajorityThreshold = MajorityThreshold; return *this; }

      /**
       * Majority threshold. It is the number of pixels over 50% that will decide whether an OFF pixel will become ON or not. For example, if the neighborhood of a pixel has 124 pixels (excluding itself), the 50% will be 62, and if you set upd a Majority threshold of 5, that means that the filter will require 67 or more neighbor pixels to be ON in order to switch the current OFF pixel to ON. The default value is 1.
       */
        unsigned int GetMajorityThreshold() const { return this->m_MajorityThreshold; }

      /**
       * Set the value associated with the Foreground (or the object) on the binary input image and the Background .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetForegroundValue ( double ForegroundValue ) { this->m_ForegroundValue = ForegroundValue; return *this; }

      /**
       * Get the value associated with the Foreground (or the object) on the binary input image and the Background .
       */
        double GetForegroundValue() const { return this->m_ForegroundValue; }

      /**
       * Set the value associated with the Foreground (or the object) on the binary input image and the Background .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       * Get the value associated with the Foreground (or the object) on the binary input image and the Background .
       */
        double GetBackgroundValue() const { return this->m_BackgroundValue; }
      /** Name of this class */
      std::string GetName() const { return std::string ("VotingBinaryIterativeHoleFillingImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector<unsigned int> & radius, unsigned int maximumNumberOfIterations, unsigned int majorityThreshold, double foregroundValue, double backgroundValue );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_Radius;
      unsigned int  m_MaximumNumberOfIterations;
      unsigned int  m_MajorityThreshold;
      double  m_ForegroundValue;
      double  m_BackgroundValue;
    };


    /**
     * \brief Fills in holes and cavities by iteratively applying a voting operation.
     *
     * This function directly calls the execute method of VotingBinaryIterativeHoleFillingImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::VotingBinaryIterativeHoleFillingImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image VotingBinaryIterativeHoleFilling ( const Image& image1, const std::vector<unsigned int> & radius = std::vector<unsigned int>(3, 1), unsigned int maximumNumberOfIterations = 10u, unsigned int majorityThreshold = 1u, double foregroundValue = 1.0, double backgroundValue = 0.0 );

  }
}
#endif
