/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkVotingBinaryHoleFillingImageFilter_h
#define sitkVotingBinaryHoleFillingImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class VotingBinaryHoleFillingImageFilter
\brief Fills in holes and cavities by applying a voting operation on each pixel.

\see Image 

\see VotingBinaryImageFilter 

\see VotingBinaryIterativeHoleFillingImageFilter 

\see Neighborhood 

\see NeighborhoodOperator 

\see NeighborhoodIterator
\sa itk::simple::VotingBinaryHoleFilling for the procedural interface
\sa itk::VotingBinaryHoleFillingImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT VotingBinaryHoleFillingImageFilter : public ImageFilter<1> {
    public:
      typedef VotingBinaryHoleFillingImageFilter Self;

      /** Destructor */
      virtual ~VotingBinaryHoleFillingImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      VotingBinaryHoleFillingImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius ( const std::vector<unsigned int> & Radius ) { this->m_Radius = Radius; return *this; }

      /** Set the values of the Radius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius( unsigned int value ) { this->m_Radius = std::vector<unsigned int>(3, value); return *this; }


      /**
       */
        std::vector<unsigned int> GetRadius() const { return this->m_Radius; }

      /**
       * Majority threshold. It is the number of pixels over 50% that will decide whether an OFF pixel will become ON or not. For example, if the neighborhood of a pixel has 124 pixels (excluding itself), the 50% will be 62, and if you set upd a Majority threshold of 5, that means that the filter will require 67 or more neighbor pixels to be ON in order to switch the current OFF pixel to ON. The default value is 1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMajorityThreshold ( unsigned int MajorityThreshold ) { this->m_MajorityThreshold = MajorityThreshold; return *this; }

      /**
       * Majority threshold. It is the number of pixels over 50% that will decide whether an OFF pixel will become ON or not. For example, if the neighborhood of a pixel has 124 pixels (excluding itself), the 50% will be 62, and if you set upd a Majority threshold of 5, that means that the filter will require 67 or more neighbor pixels to be ON in order to switch the current OFF pixel to ON. The default value is 1.
       */
        unsigned int GetMajorityThreshold() const { return this->m_MajorityThreshold; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetForegroundValue ( double ForegroundValue ) { this->m_ForegroundValue = ForegroundValue; return *this; }

      /**
       */
        double GetForegroundValue() const { return this->m_ForegroundValue; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       */
        double GetBackgroundValue() const { return this->m_BackgroundValue; }
      /** Name of this class */
      std::string GetName() const { return std::string ("VotingBinaryHoleFillingImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector<unsigned int> & radius, unsigned int majorityThreshold, double foregroundValue, double backgroundValue );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_Radius;
      unsigned int  m_MajorityThreshold;
      double  m_ForegroundValue;
      double  m_BackgroundValue;
    };


    /**
     * \brief Fills in holes and cavities by applying a voting operation on each pixel.
     *
     * This function directly calls the execute method of VotingBinaryHoleFillingImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::VotingBinaryHoleFillingImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image VotingBinaryHoleFilling ( const Image& image1, const std::vector<unsigned int> & radius = std::vector<unsigned int>(3, 1), unsigned int majorityThreshold = 1u, double foregroundValue = 1.0, double backgroundValue = 0.0 );

  }
}
#endif
