/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkThresholdImageFilter_h
#define sitkThresholdImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ThresholdImageFilter
\brief Set image values to a user-specified value if they are below, above, or between simple threshold values.

ThresholdImageFilter sets image values to a user-specified "outside" value (by default, "black") if the image values are below, above, or between simple threshold values.

The available methods are:

ThresholdAbove() : The values greater than the threshold value are set to OutsideValue

ThresholdBelow() : The values less than the threshold value are set to OutsideValue

ThresholdOutside() : The values outside the threshold range (less than lower or greater than upper) are set to OutsideValue

Note that these definitions indicate that pixels equal to the threshold value are not set to OutsideValue in any of these methods

The pixels must support the operators >= and <=.
\sa itk::simple::Threshold for the procedural interface
\sa itk::ThresholdImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ThresholdImageFilter : public ImageFilter<1> {
    public:
      typedef ThresholdImageFilter Self;

      /** Destructor */
      virtual ~ThresholdImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ThresholdImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get methods to set the lower threshold.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLower ( double Lower ) { this->m_Lower = Lower; return *this; }

      /**
       * Set/Get methods to set the lower threshold.
       */
        double GetLower() const { return this->m_Lower; }

      /**
       * Set/Get methods to set the upper threshold.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpper ( double Upper ) { this->m_Upper = Upper; return *this; }

      /**
       * Set/Get methods to set the upper threshold.
       */
        double GetUpper() const { return this->m_Upper; }

      /**
       * The pixel type must support comparison operators. Set the "outside" pixel value. The default value NumericTraits<PixelType>::ZeroValue() .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutsideValue ( double OutsideValue ) { this->m_OutsideValue = OutsideValue; return *this; }

      /**
       * Get the "outside" pixel value.
       */
        double GetOutsideValue() const { return this->m_OutsideValue; }
      /** Name of this class */
      std::string GetName() const { return std::string ("ThresholdImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double lower, double upper, double outsideValue );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_Lower;
      double  m_Upper;
      double  m_OutsideValue;
    };


    /**
     * \brief Set image values to a user-specified value if they are below, above, or between simple threshold values.
     *
     * This function directly calls the execute method of ThresholdImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ThresholdImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Threshold ( const Image& image1, double lower = 0.0, double upper = 1.0, double outsideValue = 0.0 );

  }
}
#endif
