/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkTernaryMagnitudeImageFilter_h
#define sitkTernaryMagnitudeImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class TernaryMagnitudeImageFilter
\brief Compute the pixel-wise magnitude of three images.

This class is templated over the types of the three input images and the type of the output image. Numeric conversions (castings) are done by the C++ defaults.
\sa itk::simple::TernaryMagnitude for the procedural interface
\sa itk::TernaryMagnitudeImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT TernaryMagnitudeImageFilter : public ImageFilter<3> {
    public:
      typedef TernaryMagnitudeImageFilter Self;

      /** Destructor */
      virtual ~TernaryMagnitudeImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      TernaryMagnitudeImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("TernaryMagnitudeImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1, const Image& image2, const Image& image3 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2, const Image& image3 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2, const Image& image3 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


    };


    /**
     * \brief Compute the pixel-wise magnitude of three images.
     *
     * This function directly calls the execute method of TernaryMagnitudeImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::TernaryMagnitudeImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image TernaryMagnitude ( const Image& image1, const Image& image2, const Image& image3 );

  }
}
#endif
