/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkStochasticFractalDimensionImageFilter_h
#define sitkStochasticFractalDimensionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class StochasticFractalDimensionImageFilter
\brief This filter computes the stochastic fractal dimension of the input image.

The methodology is based on Madelbrot's fractal theory and the concept of fractional Brownian motion and yields images which have been used for classification and edge enhancement.

This class which is templated over the input and output images as well as a mask image type. The input is a scalar image, an optional neighborhood radius (default = 2), and an optional mask. The mask can be specified to decrease computation time since, as the authors point out, calculation is time-consuming.

This filter was contributed by Nick Tustison and James Gee from the PICSL lab, at the University of Pennsylvania as an paper to the Insight Journal:

"Stochastic Fractal Dimension Image" https://hdl.handle.net/1926/1525 http://www.insight-journal.org/browse/publication/318 

\author Nick Tustison
\sa itk::simple::StochasticFractalDimension for the procedural interface
\sa itk::StochasticFractalDimensionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT StochasticFractalDimensionImageFilter : public ImageFilter<0> {
    public:
      typedef StochasticFractalDimensionImageFilter Self;

      /** Destructor */
      virtual ~StochasticFractalDimensionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      StochasticFractalDimensionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef RealPixelIDTypeList  PixelIDTypeList;



      /**
       * Manhattan radius used for evaluating the fractal dimension.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNeighborhoodRadius ( const std::vector<unsigned int> & NeighborhoodRadius ) { this->m_NeighborhoodRadius = NeighborhoodRadius; return *this; }

      /** Set the values of the NeighborhoodRadius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetNeighborhoodRadius( unsigned int value ) { this->m_NeighborhoodRadius = std::vector<unsigned int>(3, value); return *this; }


      /**
       * Manhattan radius used for evaluating the fractal dimension.
       */
        std::vector<unsigned int> GetNeighborhoodRadius() const { return this->m_NeighborhoodRadius; }
      /** Name of this class */
      std::string GetName() const { return std::string ("StochasticFractalDimensionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image & image, const Image & maskImage );
      Image Execute ( const Image & image );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image & image, const Image & maskImage, const std::vector<unsigned int> & neighborhoodRadius );
      Image Execute ( const Image & image, const std::vector<unsigned int> & neighborhoodRadius );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image * image, const Image * maskImage );
      template <class TImageType> Image ExecuteInternal ( const Image * image, const Image * maskImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<unsigned int>  m_NeighborhoodRadius;

    };


    /**
     * \brief This filter computes the stochastic fractal dimension of the input image.
     *
     * This function directly calls the execute method of StochasticFractalDimensionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::StochasticFractalDimensionImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image StochasticFractalDimension ( const Image & image, const Image & maskImage, const std::vector<unsigned int> & neighborhoodRadius = std::vector<unsigned int>(3, 2u) );
     SITKBasicFilters_EXPORT Image StochasticFractalDimension ( const Image & image, const std::vector<unsigned int> & neighborhoodRadius = std::vector<unsigned int>(3, 2u) );
  }
}
#endif
