/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkSmoothingRecursiveGaussianImageFilter_h
#define sitkSmoothingRecursiveGaussianImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class SmoothingRecursiveGaussianImageFilter
\brief Computes the smoothing of an image by convolution with the Gaussian kernels implemented as IIR filters.

This filter is implemented using the recursive gaussian filters. For multi-component images, the filter works on each component independently.

For this filter to be able to run in-place the input and output image types need to be the same and/or the same type as the RealImageType.
\sa itk::simple::SmoothingRecursiveGaussian for the procedural interface
\sa itk::SmoothingRecursiveGaussianImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT SmoothingRecursiveGaussianImageFilter : public ImageFilter<1> {
    public:
      typedef SmoothingRecursiveGaussianImageFilter Self;

      /** Destructor */
      virtual ~SmoothingRecursiveGaussianImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      SmoothingRecursiveGaussianImageFilter();

      /** Define the pixels types supported by this filter */
      typedef typelist::Append<BasicPixelIDTypeList, VectorPixelIDTypeList>::Type  PixelIDTypeList;



      /**
       * Set the standard deviation of the Gaussian used for smoothing. Sigma is measured in the units of image spacing. You may use the method SetSigma to set the same value across each axis or use the method SetSigmaArray if you need different values along each axis.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma ( const std::vector<double> & Sigma ) { this->m_Sigma = Sigma; return *this; }

      /** Set the values of the Sigma vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma( double value ) { this->m_Sigma = std::vector<double>(3, value); return *this; }


      /**
       * Get the Sigma scalar. If the Sigma is anisotropic, we will just return the Sigma along the first dimension.
       */
        std::vector<double> GetSigma() const { return this->m_Sigma; }

      /**
       * Set/Get the flag for normalizing the Gaussian over scale-space. This method does not effect the output of this filter.

\see RecursiveGaussianImageFilter::SetNormalizeAcrossScale
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalizeAcrossScale ( bool NormalizeAcrossScale ) { this->m_NormalizeAcrossScale = NormalizeAcrossScale; return *this; }

      /** Set the value of NormalizeAcrossScale to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeAcrossScaleOn() { return this->SetNormalizeAcrossScale(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeAcrossScaleOff() { return this->SetNormalizeAcrossScale(false); }

      /**
       * Set/Get the flag for normalizing the Gaussian over scale-space. This method does not effect the output of this filter.

\see RecursiveGaussianImageFilter::SetNormalizeAcrossScale
       */
        bool GetNormalizeAcrossScale() const { return this->m_NormalizeAcrossScale; }
      /** Name of this class */
      std::string GetName() const { return std::string ("SmoothingRecursiveGaussianImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector<double> & sigma, bool normalizeAcrossScale );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<double>  m_Sigma;
      /*  */
      bool  m_NormalizeAcrossScale;
    };


    /**
     * \brief Computes the smoothing of an image by convolution with the Gaussian kernels implemented as IIR filters.
     *
     * This function directly calls the execute method of SmoothingRecursiveGaussianImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::SmoothingRecursiveGaussianImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image SmoothingRecursiveGaussian ( const Image& image1, const std::vector<double> & sigma = std::vector<double>(3,1.0), bool normalizeAcrossScale = false );

  }
}
#endif
