/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkSimpleContourExtractorImageFilter_h
#define sitkSimpleContourExtractorImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class SimpleContourExtractorImageFilter
\brief Computes an image of contours which will be the contour of the first image.

A pixel of the source image is considered to belong to the contour if its pixel value is equal to the input foreground value and it has in its neighborhood at least one pixel which its pixel value is equal to the input background value. The output image will have pixels which will be set to the output foreground value if they belong to the contour, otherwise they will be set to the output background value.

The neighborhood "radius" is set thanks to the radius params.

\see Image 

\see Neighborhood 

\see NeighborhoodOperator 

\see NeighborhoodIterator
\sa itk::simple::SimpleContourExtractor for the procedural interface
\sa itk::SimpleContourExtractorImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT SimpleContourExtractorImageFilter : public ImageFilter<1> {
    public:
      typedef SimpleContourExtractorImageFilter Self;

      /** Destructor */
      virtual ~SimpleContourExtractorImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      SimpleContourExtractorImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set the foreground value used in order to identify a foreground pixel in the input image.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetInputForegroundValue ( double InputForegroundValue ) { this->m_InputForegroundValue = InputForegroundValue; return *this; }

      /**
       * Get the foreground value used in order to identify a foreground pixel in the input image.
       */
        double GetInputForegroundValue() const { return this->m_InputForegroundValue; }

      /**
       * Set the background value used in order to identify a background pixel in the input image.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetInputBackgroundValue ( double InputBackgroundValue ) { this->m_InputBackgroundValue = InputBackgroundValue; return *this; }

      /**
       * Get the background value used in order to identify a background pixel in the input image.
       */
        double GetInputBackgroundValue() const { return this->m_InputBackgroundValue; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius ( const std::vector<unsigned int> & Radius ) { this->m_Radius = Radius; return *this; }

      /** Set the values of the Radius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius( unsigned int value ) { this->m_Radius = std::vector<unsigned int>(3, value); return *this; }


      /**
       */
        std::vector<unsigned int> GetRadius() const { return this->m_Radius; }

      /**
       * Set the foreground value used in order to identify a foreground pixel in the output image.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputForegroundValue ( double OutputForegroundValue ) { this->m_OutputForegroundValue = OutputForegroundValue; return *this; }

      /**
       * Get the foreground value used in order to identify a foreground pixel in the output image.
       */
        double GetOutputForegroundValue() const { return this->m_OutputForegroundValue; }

      /**
       * Set the background value used in order to identify a background pixel in the output image.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputBackgroundValue ( double OutputBackgroundValue ) { this->m_OutputBackgroundValue = OutputBackgroundValue; return *this; }

      /**
       * Get the background value used in order to identify a background pixel in the output image.
       */
        double GetOutputBackgroundValue() const { return this->m_OutputBackgroundValue; }
      /** Name of this class */
      std::string GetName() const { return std::string ("SimpleContourExtractorImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double inputForegroundValue, double inputBackgroundValue, const std::vector<unsigned int> & radius, double outputForegroundValue, double outputBackgroundValue );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_InputForegroundValue;
      double  m_InputBackgroundValue;
      /*  */
      std::vector<unsigned int>  m_Radius;
      double  m_OutputForegroundValue;
      double  m_OutputBackgroundValue;
    };


    /**
     * \brief Computes an image of contours which will be the contour of the first image.
     *
     * This function directly calls the execute method of SimpleContourExtractorImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::SimpleContourExtractorImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image SimpleContourExtractor ( const Image& image1, double inputForegroundValue = 1.0, double inputBackgroundValue = 0.0, const std::vector<unsigned int> & radius = std::vector<unsigned int>(3, 1), double outputForegroundValue = 1.0, double outputBackgroundValue = 0.0 );

  }
}
#endif
