/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkShiftScaleImageFilter_h
#define sitkShiftScaleImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ShiftScaleImageFilter
\brief Shift and scale the pixels in an image.

ShiftScaleImageFilter shifts the input pixel by Shift (default 0.0) and then scales the pixel by Scale (default 1.0). All computattions are performed in the precision of the input pixel's RealType. Before assigning the computed value to the output pixel, the value is clamped at the NonpositiveMin and max of the pixel type.
\sa itk::simple::ShiftScale for the procedural interface
\sa itk::ShiftScaleImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ShiftScaleImageFilter : public ImageFilter<1> {
    public:
      typedef ShiftScaleImageFilter Self;

      /** Destructor */
      virtual ~ShiftScaleImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ShiftScaleImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get the amount to Shift each Pixel. The shift is followed by a Scale.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetShift ( double Shift ) { this->m_Shift = Shift; return *this; }

      /**
       * Set/Get the amount to Shift each Pixel. The shift is followed by a Scale.
       */
        double GetShift() const { return this->m_Shift; }

      /**
       * Set/Get the amount to Scale each Pixel. The Scale is applied after the Shift.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetScale ( double Scale ) { this->m_Scale = Scale; return *this; }

      /**
       * Set/Get the amount to Scale each Pixel. The Scale is applied after the Shift.
       */
        double GetScale() const { return this->m_Scale; }
     /**
      * Get the number of pixels that underflowed and overflowed.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     int64_t GetUnderflowCount() const { return this->m_UnderflowCount; };

     /**
      * Get the number of pixels that underflowed and overflowed.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     int64_t GetOverflowCount() const { return this->m_OverflowCount; };

      /** Name of this class */
      std::string GetName() const { return std::string ("ShiftScaleImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double shift, double scale );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInteral on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_Shift;
      double  m_Scale;
      /* Some global documentation */
      int64_t m_UnderflowCount;
      /* Some global documentation */
      int64_t m_OverflowCount;

    };


    /**
     * \brief Shift and scale the pixels in an image.
     *
     * This function directly calls the execute method of ShiftScaleImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ShiftScaleImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image ShiftScale ( const Image& image1, double shift = 0, double scale = 1.0 );

  }
}
#endif
