/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkScalarToRGBColormapImageFilter_h
#define sitkScalarToRGBColormapImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ScalarToRGBColormapImageFilter
\brief Implements pixel-wise intensity->rgb mapping operation on one image.

This class is parameterized over the type of the input image and the type of the output image.

The input image's scalar pixel values are mapped into a color map. The color map is specified by passing the SetColormap function one of the predefined maps. The following selects the "Hot" colormap: \code
RGBFilterType::Pointer colormapImageFilter = RGBFilterType::New();

colormapImageFilter->SetColormap( RGBFilterType::Hot );

\endcode

You can also specify a custom color map. This is done by creating a CustomColormapFunction, and then creating lists of values for the red, green, and blue channel. An example of setting the red channel of a colormap with only 2 colors is given below. The blue and green channels should be specified in the same manner.

\code
// Create the custom colormap

typedef itk::Function::CustomColormapFunction<RealImageType::PixelType,

RGBImageType::PixelType> ColormapType;

ColormapType::Pointer colormap = ColormapType::New();

// Setup the red channel of the colormap

ColormapType::ChannelType redChannel;

redChannel.push_back(0); redChannel.push_back(255);

colormap->SetRedChannel( channel );

\endcode

The range of values present in the input image is the range that is mapped to the entire range of colors.

This code was contributed in the Insight Journal paper: "Meeting Andy Warhol Somewhere Over the Rainbow: RGB Colormapping and ITK" by Tustison N., Zhang H., Lehmann G., Yushkevich P., Gee J. https://hdl.handle.net/1926/1452 http://www.insight-journal.org/browse/publication/285 

\see BinaryFunctionImageFilter TernaryFunctionImageFilter
\sa itk::simple::ScalarToRGBColormap for the procedural interface
\sa itk::ScalarToRGBColormapImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ScalarToRGBColormapImageFilter : public ImageFilter<1> {
    public:
      typedef ScalarToRGBColormapImageFilter Self;

      /** Destructor */
      virtual ~ScalarToRGBColormapImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ScalarToRGBColormapImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      typedef enum {Red,Green,Blue,Grey,Hot,Cool,Spring,Summer,Autumn,Winter,Copper,Jet,HSV,OverUnder} ColormapType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetColormap ( ColormapType Colormap ) { this->m_Colormap = Colormap; return *this; }

      /**
       * Set/Get the colormap object.
       */
        ColormapType GetColormap() const { return this->m_Colormap; }

      /**
       * Set/Get UseInputImageExtremaForScaling. If true, the colormap uses the min and max values from the image to scale appropriately. Otherwise, these values can be set in the colormap manually.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseInputImageExtremaForScaling ( bool UseInputImageExtremaForScaling ) { this->m_UseInputImageExtremaForScaling = UseInputImageExtremaForScaling; return *this; }

      /** Set the value of UseInputImageExtremaForScaling to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseInputImageExtremaForScalingOn() { return this->SetUseInputImageExtremaForScaling(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseInputImageExtremaForScalingOff() { return this->SetUseInputImageExtremaForScaling(false); }

      /**
       * Set/Get UseInputImageExtremaForScaling. If true, the colormap uses the min and max values from the image to scale appropriately. Otherwise, these values can be set in the colormap manually.
       */
        bool GetUseInputImageExtremaForScaling() const { return this->m_UseInputImageExtremaForScaling; }
      /** Name of this class */
      std::string GetName() const { return std::string ("ScalarToRGBColormapImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, ScalarToRGBColormapImageFilter::ColormapType colormap, bool useInputImageExtremaForScaling );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      ColormapType  m_Colormap;
      bool  m_UseInputImageExtremaForScaling;
    };


    /**
     * \brief Implements pixel-wise intensity->rgb mapping operation on one image.
     *
     * This function directly calls the execute method of ScalarToRGBColormapImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ScalarToRGBColormapImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image ScalarToRGBColormap ( const Image& image1, ScalarToRGBColormapImageFilter::ColormapType colormap = itk::simple::ScalarToRGBColormapImageFilter::Grey, bool useInputImageExtremaForScaling = true );

  }
}
#endif
