/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkSaltAndPepperNoiseImageFilter_h
#define sitkSaltAndPepperNoiseImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class SaltAndPepperNoiseImageFilter
\brief Alter an image with fixed value impulse noise, often called salt and pepper noise.

Salt and pepper noise is a special kind of impulse noise where the value of the noise is either the maximum possible value in the image or its minimum. It can be modeled as:

\par 
\f$ I = \begin{cases} M, & \quad \text{if } U < p/2 \\ m, & \quad \text{if } U > 1 - p/2 \\ I_0, & \quad \text{if } p/2 \geq U \leq 1 - p/2 \end{cases} \f$ 

\par 
where \f$ p \f$ is the probability of the noise event, \f$ U \f$ is a uniformly distributed random variable in the \f$ [0,1] \f$ range, \f$ M \f$ is the greatest possible pixel value, and \f$ m \f$ the smallest possible pixel value.

Pixel alteration occurs at a user defined probability. Salt and pepper pixels are equally distributed.

\author Gaetan Lehmann

This code was contributed in the Insight Journal paper "Noise
Simulation". https://hdl.handle.net/10380/3158
\sa itk::simple::SaltAndPepperNoise for the procedural interface
\sa itk::SaltAndPepperNoiseImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT SaltAndPepperNoiseImageFilter : public ImageFilter<1> {
    public:
      typedef SaltAndPepperNoiseImageFilter Self;

      /** Destructor */
      virtual ~SaltAndPepperNoiseImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      SaltAndPepperNoiseImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get the probability of the salt and pepper noise event. Defaults to 0.01.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetProbability ( double Probability ) { this->m_Probability = Probability; return *this; }

      /**
       * Set/Get the probability of the salt and pepper noise event. Defaults to 0.01.
       */
        double GetProbability() const { return this->m_Probability; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSeed ( uint32_t Seed ) { this->m_Seed = Seed; return *this; }

      /**
       */
        uint32_t GetSeed() const { return this->m_Seed; }
      /** Name of this class */
      std::string GetName() const { return std::string ("SaltAndPepperNoiseImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double probability, uint32_t seed );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInteral on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_Probability;
      uint32_t  m_Seed;
    };


    /**
     * \brief Alter an image with fixed value impulse noise, often called salt and pepper noise.
     *
     * This function directly calls the execute method of SaltAndPepperNoiseImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::SaltAndPepperNoiseImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image SaltAndPepperNoise ( const Image& image1, double probability = 0.01, uint32_t seed = (uint32_t) itk::simple::sitkWallClock );

  }
}
#endif
