/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkRoundImageFilter_h
#define sitkRoundImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class RoundImageFilter
\brief Rounds the value of each pixel.

The computations are performed using itk::Math::Round(x).
\sa itk::simple::Round for the procedural interface
\sa itk::RoundImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT RoundImageFilter : public ImageFilter<1> {
    public:
      typedef RoundImageFilter Self;

      /** Destructor */
      virtual ~RoundImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      RoundImageFilter();

      /** Define the pixels types supported by this filter */
      typedef RealPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("RoundImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


    };


    /**
     * \brief Rounds the value of each pixel.
     *
     * This function directly calls the execute method of RoundImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::RoundImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Round ( const Image& image1 );

  }
}
#endif
