/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkRichardsonLucyDeconvolutionImageFilter_h
#define sitkRichardsonLucyDeconvolutionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class RichardsonLucyDeconvolutionImageFilter
\brief Deconvolve an image using the Richardson-Lucy deconvolution algorithm.

This filter implements the Richardson-Lucy deconvolution algorithm as defined in Bertero M and Boccacci P, "Introduction to Inverse
Problems in Imaging", 1998. The algorithm assumes that the input image has been formed by a linear shift-invariant system with a known kernel.

The Richardson-Lucy algorithm assumes that noise in the image follows a Poisson distribution and that the distribution for each pixel is independent of the other pixels.

This code was adapted from the Insight Journal contribution:

"Deconvolution: infrastructure and reference algorithms" by Gaetan Lehmann https://hdl.handle.net/10380/3207 

\author Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France 

\author Cory Quammen, The University of North Carolina at Chapel Hill

\see IterativeDeconvolutionImageFilter 

\see LandweberDeconvolutionImageFilter 

\see ProjectedLandweberDeconvolutionImageFilter
\sa itk::simple::RichardsonLucyDeconvolution for the procedural interface
\sa itk::RichardsonLucyDeconvolutionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT RichardsonLucyDeconvolutionImageFilter : public ImageFilter<2> {
    public:
      typedef RichardsonLucyDeconvolutionImageFilter Self;

      /** Destructor */
      virtual ~RichardsonLucyDeconvolutionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      RichardsonLucyDeconvolutionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set the number of iterations.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNumberOfIterations ( int NumberOfIterations ) { this->m_NumberOfIterations = NumberOfIterations; return *this; }

      /**
       * Get the number of iterations.
       */
        int GetNumberOfIterations() const { return this->m_NumberOfIterations; }

      /**
       * Normalize the output image by the sum of the kernel components

       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalize ( bool Normalize ) { this->m_Normalize = Normalize; return *this; }

      /** Set the value of Normalize to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOn() { return this->SetNormalize(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOff() { return this->SetNormalize(false); }

      /**
       */
        bool GetNormalize() const { return this->m_Normalize; }

      typedef enum {ZERO_PAD,ZERO_FLUX_NEUMANN_PAD,PERIODIC_PAD} BoundaryConditionType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBoundaryCondition ( BoundaryConditionType BoundaryCondition ) { this->m_BoundaryCondition = BoundaryCondition; return *this; }

      /**
       */
        BoundaryConditionType GetBoundaryCondition() const { return this->m_BoundaryCondition; }

      typedef enum {SAME,VALID} OutputRegionModeType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputRegionMode ( OutputRegionModeType OutputRegionMode ) { this->m_OutputRegionMode = OutputRegionMode; return *this; }

      /**
       */
        OutputRegionModeType GetOutputRegionMode() const { return this->m_OutputRegionMode; }
      /** Name of this class */
      std::string GetName() const { return std::string ("RichardsonLucyDeconvolutionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter on the input images with the given parameters */
      Image Execute ( const Image& image1, const Image& image2, int numberOfIterations, bool normalize, RichardsonLucyDeconvolutionImageFilter::BoundaryConditionType boundaryCondition, RichardsonLucyDeconvolutionImageFilter::OutputRegionModeType outputRegionMode );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      int  m_NumberOfIterations;
      /*  */
      bool  m_Normalize;
      BoundaryConditionType  m_BoundaryCondition;
      OutputRegionModeType  m_OutputRegionMode;
    };


    /**
     * \brief Deconvolve an image using the Richardson-Lucy deconvolution algorithm.
     *
     * This function directly calls the execute method of RichardsonLucyDeconvolutionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::RichardsonLucyDeconvolutionImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image RichardsonLucyDeconvolution ( const Image& image1, const Image& image2, int numberOfIterations = 1, bool normalize = false, RichardsonLucyDeconvolutionImageFilter::BoundaryConditionType boundaryCondition = itk::simple::RichardsonLucyDeconvolutionImageFilter::ZERO_FLUX_NEUMANN_PAD, RichardsonLucyDeconvolutionImageFilter::OutputRegionModeType outputRegionMode = itk::simple::RichardsonLucyDeconvolutionImageFilter::SAME );

  }
}
#endif
