/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkRescaleIntensityImageFilter_h
#define sitkRescaleIntensityImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class RescaleIntensityImageFilter
\brief Applies a linear transformation to the intensity levels of the input Image .

RescaleIntensityImageFilter applies pixel-wise a linear transformation to the intensity values of input image pixels. The linear transformation is defined by the user in terms of the minimum and maximum values that the output image should have.

The following equation gives the mapping of the intensity values

\par 
 \f[ outputPixel = ( inputPixel - inputMin) \cdot \frac{(outputMax - outputMin )}{(inputMax - inputMin)} + outputMin \f] 

All computations are performed in the precision of the input pixel's RealType. Before assigning the computed value to the output pixel.

NOTE: In this filter the minimum and maximum values of the input image are computed internally using the MinimumMaximumImageCalculator . Users are not supposed to set those values in this filter. If you need a filter where you can set the minimum and maximum values of the input, please use the IntensityWindowingImageFilter . If you want a filter that can use a user-defined linear transformation for the intensity, then please use the ShiftScaleImageFilter .

\see IntensityWindowingImageFilter
\sa itk::simple::RescaleIntensity for the procedural interface
\sa itk::RescaleIntensityImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT RescaleIntensityImageFilter : public ImageFilter<1> {
    public:
      typedef RescaleIntensityImageFilter Self;

      /** Destructor */
      virtual ~RescaleIntensityImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      RescaleIntensityImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputMinimum ( double OutputMinimum ) { this->m_OutputMinimum = OutputMinimum; return *this; }

      /**
       */
        double GetOutputMinimum() const { return this->m_OutputMinimum; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputMaximum ( double OutputMaximum ) { this->m_OutputMaximum = OutputMaximum; return *this; }

      /**
       */
        double GetOutputMaximum() const { return this->m_OutputMaximum; }
      /** Name of this class */
      std::string GetName() const { return std::string ("RescaleIntensityImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double outputMinimum, double outputMaximum );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInteral on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Output minimum */
      double  m_OutputMinimum;
      /* Output maximum */
      double  m_OutputMaximum;
    };


    /**
     * \brief Applies a linear transformation to the intensity levels of the input Image .
     *
     * This function directly calls the execute method of RescaleIntensityImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::RescaleIntensityImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image RescaleIntensity ( const Image& image1, double outputMinimum = 0, double outputMaximum = 255 );

  }
}
#endif
