/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkRelabelLabelMapFilter_h
#define sitkRelabelLabelMapFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class RelabelLabelMapFilter
\brief This filter relabels the LabelObjects; the new labels are arranged consecutively with consideration for the background value.

This filter takes the LabelObjects from the input and reassigns them to the output by calling the PushLabelObject method, which by default, attempts to reorganize the labels consecutively. The user can assign an arbitrary value to the background; the filter will assign the labels consecutively by skipping the background value.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176 \author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

\see ShapeLabelObject , RelabelComponentImageFilter
\sa itk::simple::RelabelLabelMapFilter for the procedural interface
\sa itk::RelabelLabelMapFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT RelabelLabelMapFilter : public ImageFilter<1> {
    public:
      typedef RelabelLabelMapFilter Self;

      /** Destructor */
      virtual ~RelabelLabelMapFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      RelabelLabelMapFilter();

      /** Define the pixels types supported by this filter */
      typedef LabelPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReverseOrdering ( bool ReverseOrdering ) { this->m_ReverseOrdering = ReverseOrdering; return *this; }

      /** Set the value of ReverseOrdering to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER ReverseOrderingOn() { return this->SetReverseOrdering(true); }
      SITK_RETURN_SELF_TYPE_HEADER ReverseOrderingOff() { return this->SetReverseOrdering(false); }

      /**
       */
        bool GetReverseOrdering() const { return this->m_ReverseOrdering; }
      /** Name of this class */
      std::string GetName() const { return std::string ("RelabelLabelMapFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, bool reverseOrdering );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_ReverseOrdering;
    };


    /**
     * \brief This filter relabels the LabelObjects; the new labels are arranged consecutively with consideration for the background value.
     *
     * This function directly calls the execute method of RelabelLabelMapFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::RelabelLabelMapFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image RelabelLabelMap ( const Image& image1, bool reverseOrdering = true );

  }
}
#endif
