/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkPasteImageFilter_h
#define sitkPasteImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class PasteImageFilter
\brief Paste an image into another image.

PasteImageFilter allows you to take a section of one image and paste into another image. The SetDestinationIndex() method prescribes where in the first input to start pasting data from the second input. The SetSourceRegion method prescribes the section of the second image to paste into the first. If the output requested region does not include the SourceRegion after it has been repositioned to DestinationIndex, then the output will just be a copy of the input.

The two inputs and output image will have the same pixel type.
\sa itk::simple::Paste for the procedural interface
\sa itk::PasteImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT PasteImageFilter : public ImageFilter<0> {
    public:
      typedef PasteImageFilter Self;

      /** Destructor */
      virtual ~PasteImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      PasteImageFilter();

      /** Define the pixels types supported by this filter */
      typedef NonLabelPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSourceSize ( const std::vector<unsigned int> & SourceSize ) { this->m_SourceSize = SourceSize; return *this; }

      /**
       */
        std::vector<unsigned int> GetSourceSize() const { return this->m_SourceSize; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSourceIndex ( const std::vector<int> & SourceIndex ) { this->m_SourceIndex = SourceIndex; return *this; }

      /**
       */
        std::vector<int> GetSourceIndex() const { return this->m_SourceIndex; }

      /**
       * Set/Get the destination index (where in the first input the second input will be pasted.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDestinationIndex ( const std::vector<int> & DestinationIndex ) { this->m_DestinationIndex = DestinationIndex; return *this; }

      /**
       * Set/Get the destination index (where in the first input the second input will be pasted.
       */
        std::vector<int> GetDestinationIndex() const { return this->m_DestinationIndex; }
      /** Name of this class */
      std::string GetName() const { return std::string ("PasteImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image & destinationImage, const Image & sourceImage );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image & destinationImage, const Image & sourceImage, const std::vector<unsigned int> & sourceSize, const std::vector<int> & sourceIndex, const std::vector<int> & destinationIndex );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image * destinationImage, const Image * sourceImage );
      template <class TImageType> Image ExecuteInternal ( const Image * destinationImage, const Image * sourceImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<unsigned int>  m_SourceSize;
      std::vector<int>  m_SourceIndex;
      std::vector<int>  m_DestinationIndex;
    };


    /**
     * \brief Paste an image into another image.
     *
     * This function directly calls the execute method of PasteImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::PasteImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Paste ( const Image & destinationImage, const Image & sourceImage, const std::vector<unsigned int> & sourceSize = std::vector<unsigned int>(3, 1), const std::vector<int> & sourceIndex = std::vector<int>(3, 0), const std::vector<int> & destinationIndex = std::vector<int>(3, 0) );

  }
}
#endif
