/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkObjectnessMeasureImageFilter_h
#define sitkObjectnessMeasureImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ObjectnessMeasureImageFilter
\brief Enhance M-dimensional objects in N-dimensional images.

This filter is a generalization of Frangi's vesselness measurement for detecting M-dimensional object in N-dimensional space. For example a vessel is a 1-D object in 3-D space. The filter can enhance blob-like structures (M=0), vessel-like structures (M=1), 2D plate-like structures (M=2), hyper-plate-like structures (M=3) in N-dimensional images, with M<N.

This filter takes a scalar image as input and produces a real valued image as output which contains the objectness measure at each pixel. Internally, it computes a Hessian via discrete central differences. Before applying this filter it is expected that a Gaussian smoothing filter at an appropriate scale (sigma) was applied to the input image.

The enhancement is based on the eigenvalues of the Hessian matrix. For the Frangi's vesselness case were M=1 and N=3 we have the 3 eigenvalues such that \f$ | \lambda_1 | < | \lambda_2 | < |\lambda_3 | \f$ . The formula follows:

 \f[ R_A = \frac{|\lambda_2|}{|\lambda_3|}, \; R_B = \frac{|\lambda_2|}{|\lambda_2\lambda_3|}, \; S = \sqrt{\lambda_1^2+\lambda_2^2+\lambda_3^2} \f] \f[ V_{\sigma}= \begin{cases} (1-e^{-\frac{R_A^2}{2\alpha^2}}) \cdot e^{\frac{R_B^2}{2\beta^2}} \cdot (1-e^{-\frac{S^2}{2\gamma^2}}) & \text{if } \lambda_2<0 \text{ and } \lambda_3<0 \text{,}\\ 0 & \text{otherwise} \end{cases} \f] 

\par References
Antiga, L. Generalizing vesselness with respect to dimensionality and shape. https://hdl.handle.net/1926/576 

\par 
Frangi, AF, Niessen, WJ, Vincken, KL, & Viergever, MA (1998). Multiscale Vessel Enhancement Filtering. In Wells, WM, Colchester, A, & Delp, S, Editors, MICCAI '98 Medical Image Computing and Computer-Assisted Intervention, Lecture Notes in Computer Science, pages 130-137, Springer Verlag, 1998.

\see itk::HessianToObjectnessMeasureImageFilter
\sa itk::simple::ObjectnessMeasure for the procedural interface
\sa itk::ObjectnessMeasureImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ObjectnessMeasureImageFilter : public ImageFilter<1> {
    public:
      typedef ObjectnessMeasureImageFilter Self;

      /** Destructor */
      virtual ~ObjectnessMeasureImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ObjectnessMeasureImageFilter();

      /** Define the pixels types supported by this filter */
      typedef RealPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get Alpha, the weight corresponding to R_A (the ratio of the smallest eigenvalue that has to be large to the larger ones). Smaller values lead to increased sensitivity to the object dimensionality.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAlpha ( double Alpha ) { this->m_Alpha = Alpha; return *this; }

      /**
       * Set/Get Alpha, the weight corresponding to R_A (the ratio of the smallest eigenvalue that has to be large to the larger ones). Smaller values lead to increased sensitivity to the object dimensionality.
       */
        double GetAlpha() const { return this->m_Alpha; }

      /**
       * Set/Get Beta, the weight corresponding to R_B (the ratio of the largest eigenvalue that has to be small to the larger ones). Smaller values lead to increased sensitivity to the object dimensionality.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBeta ( double Beta ) { this->m_Beta = Beta; return *this; }

      /**
       * Set/Get Beta, the weight corresponding to R_B (the ratio of the largest eigenvalue that has to be small to the larger ones). Smaller values lead to increased sensitivity to the object dimensionality.
       */
        double GetBeta() const { return this->m_Beta; }

      /**
       * Set/Get Gamma, the weight corresponding to S (the Frobenius norm of the Hessian matrix, or second-order structureness)
       */
      SITK_RETURN_SELF_TYPE_HEADER SetGamma ( double Gamma ) { this->m_Gamma = Gamma; return *this; }

      /**
       * Set/Get Gamma, the weight corresponding to S (the Frobenius norm of the Hessian matrix, or second-order structureness)
       */
        double GetGamma() const { return this->m_Gamma; }

      /**
       * Toggle scaling the objectness measure with the magnitude of the largest absolute eigenvalue
       */
      SITK_RETURN_SELF_TYPE_HEADER SetScaleObjectnessMeasure ( bool ScaleObjectnessMeasure ) { this->m_ScaleObjectnessMeasure = ScaleObjectnessMeasure; return *this; }

      /** Set the value of ScaleObjectnessMeasure to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER ScaleObjectnessMeasureOn() { return this->SetScaleObjectnessMeasure(true); }
      SITK_RETURN_SELF_TYPE_HEADER ScaleObjectnessMeasureOff() { return this->SetScaleObjectnessMeasure(false); }

      /**
       * Toggle scaling the objectness measure with the magnitude of the largest absolute eigenvalue
       */
        bool GetScaleObjectnessMeasure() const { return this->m_ScaleObjectnessMeasure; }

      /**
       * Set/Get the dimensionality of the object (0: points (blobs), 1: lines (vessels), 2: planes (plate-like structures), 3: hyper-planes. ObjectDimension must be smaller than ImageDimension.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetObjectDimension ( unsigned int ObjectDimension ) { this->m_ObjectDimension = ObjectDimension; return *this; }

      /**
       * Set/Get the dimensionality of the object (0: points (blobs), 1: lines (vessels), 2: planes (plate-like structures), 3: hyper-planes. ObjectDimension must be smaller than ImageDimension.
       */
        unsigned int GetObjectDimension() const { return this->m_ObjectDimension; }

      /**
       * Enhance bright structures on a dark background if true, the opposite if false.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBrightObject ( bool BrightObject ) { this->m_BrightObject = BrightObject; return *this; }

      /** Set the value of BrightObject to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER BrightObjectOn() { return this->SetBrightObject(true); }
      SITK_RETURN_SELF_TYPE_HEADER BrightObjectOff() { return this->SetBrightObject(false); }

      /**
       * Enhance bright structures on a dark background if true, the opposite if false.
       */
        bool GetBrightObject() const { return this->m_BrightObject; }
      /** Name of this class */
      std::string GetName() const { return std::string ("ObjectnessMeasureImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double alpha, double beta, double gamma, bool scaleObjectnessMeasure, unsigned int objectDimension, bool brightObject );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_Alpha;
      /* Alpha */
      double  m_Beta;
      double  m_Gamma;
      bool  m_ScaleObjectnessMeasure;
      unsigned int  m_ObjectDimension;
      bool  m_BrightObject;
    };


    /**
     * \brief Enhance M-dimensional objects in N-dimensional images.
     *
     * This function directly calls the execute method of ObjectnessMeasureImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ObjectnessMeasureImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image ObjectnessMeasure ( const Image& image1, double alpha = 0.5, double beta = 0.5, double gamma = 5, bool scaleObjectnessMeasure = true, unsigned int objectDimension = 1u, bool brightObject = true );

  }
}
#endif
