/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkNotImageFilter_h
#define sitkNotImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class NotImageFilter
\brief Implements the NOT logical operator pixel-wise on an image.

This class is templated over the type of an input image and the type of the output image. Numeric conversions (castings) are done by the C++ defaults.

Since the logical NOT operation operates only on boolean types, the input type must be implicitly convertible to bool, which is only defined in C++ for integer types, the images passed to this filter must comply with the requirement of using integer pixel type.

The total operation over one pixel will be

\code
if( !A )

 {

 return this->m_ForegroundValue;

 }

return this->m_BackgroundValue;

\endcode

Where "!" is the unary Logical NOT operator in C++.
\sa itk::simple::Not for the procedural interface
\sa itk::NotImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT NotImageFilter : public ImageFilter<1> {
    public:
      typedef NotImageFilter Self;

      /** Destructor */
      virtual ~NotImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      NotImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("NotImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


    };


    /**
     * \brief Implements the NOT logical operator pixel-wise on an image.
     *
     * This function directly calls the execute method of NotImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::NotImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Not ( const Image& image1 );

  }
}
#endif
