/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkNormalizeToConstantImageFilter_h
#define sitkNormalizeToConstantImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class NormalizeToConstantImageFilter
\brief Scales image pixel intensities to make the sum of all pixels equal a user-defined constant.

The default value of the constant is 1. It can be changed with SetConstant() .

This transform is especially useful for normalizing a convolution kernel.

This code was contributed in the Insight Journal paper: "FFT based
convolution" by Lehmann G. https://hdl.handle.net/10380/3154 

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

\see NormalizeImageFilter 

\see StatisticsImageFilter 

\see DivideImageFilter
\sa itk::simple::NormalizeToConstant for the procedural interface
\sa itk::NormalizeToConstantImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT NormalizeToConstantImageFilter : public ImageFilter<1> {
    public:
      typedef NormalizeToConstantImageFilter Self;

      /** Destructor */
      virtual ~NormalizeToConstantImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      NormalizeToConstantImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/get the normalization constant.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetConstant ( double Constant ) { this->m_Constant = Constant; return *this; }

      /**
       * Set/get the normalization constant.
       */
        double GetConstant() const { return this->m_Constant; }
      /** Name of this class */
      std::string GetName() const { return std::string ("NormalizeToConstantImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double constant );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInteral on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_Constant;
    };


    /**
     * \brief Scales image pixel intensities to make the sum of all pixels equal a user-defined constant.
     *
     * This function directly calls the execute method of NormalizeToConstantImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::NormalizeToConstantImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image NormalizeToConstant ( const Image& image1, double constant = 1.0 );

  }
}
#endif
