/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkNormalizeImageFilter_h
#define sitkNormalizeImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class NormalizeImageFilter
\brief Normalize an image by setting its mean to zero and variance to one.

NormalizeImageFilter shifts and scales an image so that the pixels in the image have a zero mean and unit variance. This filter uses StatisticsImageFilter to compute the mean and variance of the input and then applies ShiftScaleImageFilter to shift and scale the pixels.

NB: since this filter normalizes the data to lie within -1 to 1, integral types will produce an image that DOES NOT HAVE a unit variance.

\see NormalizeToConstantImageFilter
\sa itk::simple::Normalize for the procedural interface
\sa itk::NormalizeImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT NormalizeImageFilter : public ImageFilter<1> {
    public:
      typedef NormalizeImageFilter Self;

      /** Destructor */
      virtual ~NormalizeImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      NormalizeImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("NormalizeImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInteral on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


    };


    /**
     * \brief Normalize an image by setting its mean to zero and variance to one.
     *
     * This function directly calls the execute method of NormalizeImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::NormalizeImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Normalize ( const Image& image1 );

  }
}
#endif
