/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkNeighborhoodConnectedImageFilter_h
#define sitkNeighborhoodConnectedImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkRegionGrowingImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkBasicFilters.h"

namespace itk {
  namespace simple {

    /**\class NeighborhoodConnectedImageFilter
\brief Label pixels that are connected to a seed and lie within a neighborhood.

NeighborhoodConnectedImageFilter labels pixels with ReplaceValue that are connected to an initial Seed AND whose neighbors all lie within a Lower and Upper threshold range.
\sa itk::simple::NeighborhoodConnected for the procedural interface
\sa itk::NeighborhoodConnectedImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT NeighborhoodConnectedImageFilter : public ImageFilter<1> {
    public:
      typedef NeighborhoodConnectedImageFilter Self;

      /** Destructor */
      virtual ~NeighborhoodConnectedImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      NeighborhoodConnectedImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get the lower threshold. The default is 0.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLower ( double Lower ) { this->m_Lower = Lower; return *this; }

      /**
       * Set/Get the lower threshold. The default is 0.
       */
        double GetLower() const { return this->m_Lower; }

      /**
       * Set/Get the upper threshold. The default is the largest possible value for the InputPixelType.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpper ( double Upper ) { this->m_Upper = Upper; return *this; }

      /**
       * Set/Get the upper threshold. The default is the largest possible value for the InputPixelType.
       */
        double GetUpper() const { return this->m_Upper; }

      /**
       * Set the radius of the neighborhood used for a mask.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius ( const std::vector<unsigned int> & Radius ) { this->m_Radius = Radius; return *this; }

      /** Set the values of the Radius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius( unsigned int value ) { this->m_Radius = std::vector<unsigned int>(3, value); return *this; }


      /**
       * Get the radius of the neighborhood used to compute the median
       */
        std::vector<unsigned int> GetRadius() const { return this->m_Radius; }

      /**
       * Set/Get value to replace thresholded pixels. Pixels that lie * within Lower and Upper (inclusive) will be replaced with this value. The default is 1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReplaceValue ( double ReplaceValue ) { this->m_ReplaceValue = ReplaceValue; return *this; }

      /**
       * Set/Get value to replace thresholded pixels. Pixels that lie * within Lower and Upper (inclusive) will be replaced with this value. The default is 1.
       */
        double GetReplaceValue() const { return this->m_ReplaceValue; }
      /** Set SeedList */
      SITK_RETURN_SELF_TYPE_HEADER SetSeedList ( const std::vector< std::vector<unsigned int> > &t )
        {
        this->m_SeedList = t; return *this;
        }

      /** Get SeedList */
      std::vector< std::vector<unsigned int> > GetSeedList() const
        {
        return this->m_SeedList;
        }

      /** ClearSeeds - Clear out all seeds in the list */
      SITK_RETURN_SELF_TYPE_HEADER ClearSeeds( )
        {
        this->m_SeedList.clear();
        return *this;
        }

      /** SetSeed - Set list to a single seed */
      SITK_RETURN_SELF_TYPE_HEADER SetSeed( const std::vector<unsigned int> &idx )
        {
        this->m_SeedList.clear();
        this->m_SeedList.push_back(idx);
        return *this;
        }

      /** AddSeed - Add a seed to the end of the list */
      SITK_RETURN_SELF_TYPE_HEADER AddSeed( const std::vector<unsigned int> &idx )
        {
        this->m_SeedList.push_back(idx);
        return *this;
        }

      /** Name of this class */
      std::string GetName() const { return std::string ("NeighborhoodConnectedImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector< std::vector<unsigned int> > &seedList, double lower, double upper, const std::vector<unsigned int> & radius, double replaceValue );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_Lower;
      double  m_Upper;
      /* Radius of the neighborhood used to compute the median */
      std::vector<unsigned int>  m_Radius;
      /* Pixels that lie within Lower and Upper (inclusive)
       will be replaced with this value. The default is 1. */
      double  m_ReplaceValue;

      /** List of interor seed points used to initialize the region growing segmentation */
      std::vector< std::vector<unsigned int> > m_SeedList;

    };


    /**
     * itk::simple::NeighborhoodConnectedImageFilter Functional Interface
     *
     * This function directly calls the execute method of NeighborhoodConnectedImageFilter
     * in order to support a fully functional API
     */
Image SITKBasicFilters_EXPORT NeighborhoodConnected ( const Image& image1, const std::vector< std::vector<unsigned int> > &seedList, double lower = 0, double upper = 1, const std::vector<unsigned int> & radius = std::vector<unsigned int>(3, 1), double replaceValue = 1 );


  } // end namespace simple
} // end namespace itk
#endif
