/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkMultiplyImageFilter_h
#define sitkMultiplyImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkBinaryFunctorFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class MultiplyImageFilter
\brief Pixel-wise multiplication of two images.

This class is templated over the types of the two input images and the type of the output image. Numeric conversions (castings) are done by the C++ defaults.
\sa itk::simple::Multiply for the procedural interface
\sa itk::MultiplyImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT MultiplyImageFilter : public ImageFilter<2> {
    public:
      typedef MultiplyImageFilter Self;

      /** Destructor */
      virtual ~MultiplyImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      MultiplyImageFilter();

      /** Define the pixels types supported by this filter */
      typedef typelist::Append<BasicPixelIDTypeList, ComplexPixelIDTypeList>::Type  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("MultiplyImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter with an image and a constant */
      Image Execute ( const Image& image1, double constant );
      Image Execute ( double constant, const Image& image2 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;
      typedef Image (Self::*MemberFunction1Type)( double constant, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( double constant, const Image& image2 );
      friend struct detail::MemberFunctionAddressor<MemberFunction1Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction1Type> > m_MemberFactory1;

      typedef Image (Self::*MemberFunction2Type)( const Image& image1, double constant );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, double constant );
      friend struct detail::MemberFunctionAddressor<MemberFunction2Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction2Type> > m_MemberFactory2;


    };


    /**
     * \brief Pixel-wise multiplication of two images.
     *
     * This function directly calls the execute method of MultiplyImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::MultiplyImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Multiply ( const Image& image1, const Image& image2 );

    SITKBasicFilters_EXPORT Image Multiply ( const Image& image1, double constant );
    SITKBasicFilters_EXPORT Image Multiply ( double constant, const Image& image2 );
  }
}
#endif
