/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkModulusImageFilter_h
#define sitkModulusImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkBinaryFunctorFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ModulusImageFilter
\brief Computes the modulus (x % dividend) pixel-wise.

The input pixel type must support the c++ modulus operator (%).

If the dividend is zero, the maximum value will be returned.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.
\sa itk::simple::Modulus for the procedural interface
\sa itk::ModulusImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ModulusImageFilter : public ImageFilter<2> {
    public:
      typedef ModulusImageFilter Self;

      /** Destructor */
      virtual ~ModulusImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ModulusImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("ModulusImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter with an image and a constant */
      Image Execute ( const Image& image1, uint32_t constant );
      Image Execute ( uint32_t constant, const Image& image2 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;
      typedef Image (Self::*MemberFunction1Type)( uint32_t constant, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( uint32_t constant, const Image& image2 );
      friend struct detail::MemberFunctionAddressor<MemberFunction1Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction1Type> > m_MemberFactory1;

      typedef Image (Self::*MemberFunction2Type)( const Image& image1, uint32_t constant );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, uint32_t constant );
      friend struct detail::MemberFunctionAddressor<MemberFunction2Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction2Type> > m_MemberFactory2;


    };


    /**
     * \brief Computes the modulus (x % dividend) pixel-wise.
     *
     * This function directly calls the execute method of ModulusImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ModulusImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Modulus ( const Image& image1, const Image& image2 );

    SITKBasicFilters_EXPORT Image Modulus ( const Image& image1, uint32_t constant );
    SITKBasicFilters_EXPORT Image Modulus ( uint32_t constant, const Image& image2 );
  }
}
#endif
