/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkMaximumImageFilter_h
#define sitkMaximumImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkBinaryFunctorFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class MaximumImageFilter
\brief Implements a pixel-wise operator Max(a,b) between two images.

The pixel values of the output image are the maximum between the corresponding pixels of the two input images.

This class is templated over the types of the two input images and the type of the output image. Numeric conversions (castings) are done by the C++ defaults.
\sa itk::simple::Maximum for the procedural interface
\sa itk::MaximumImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT MaximumImageFilter : public ImageFilter<2> {
    public:
      typedef MaximumImageFilter Self;

      /** Destructor */
      virtual ~MaximumImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      MaximumImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("MaximumImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter with an image and a constant */
      Image Execute ( const Image& image1, double constant );
      Image Execute ( double constant, const Image& image2 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;
      typedef Image (Self::*MemberFunction1Type)( double constant, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( double constant, const Image& image2 );
      friend struct detail::MemberFunctionAddressor<MemberFunction1Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction1Type> > m_MemberFactory1;

      typedef Image (Self::*MemberFunction2Type)( const Image& image1, double constant );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, double constant );
      friend struct detail::MemberFunctionAddressor<MemberFunction2Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction2Type> > m_MemberFactory2;


    };


    /**
     * \brief Implements a pixel-wise operator Max(a,b) between two images.
     *
     * This function directly calls the execute method of MaximumImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::MaximumImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Maximum ( const Image& image1, const Image& image2 );

    SITKBasicFilters_EXPORT Image Maximum ( const Image& image1, double constant );
    SITKBasicFilters_EXPORT Image Maximum ( double constant, const Image& image2 );
  }
}
#endif
