/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLog10ImageFilter_h
#define sitkLog10ImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class Log10ImageFilter
\brief Computes the log10 of each pixel.

The computation is performed using std::log10(x).
\sa itk::simple::Log10 for the procedural interface
\sa itk::Log10ImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT Log10ImageFilter : public ImageFilter<1> {
    public:
      typedef Log10ImageFilter Self;

      /** Destructor */
      virtual ~Log10ImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      Log10ImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("Log10ImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInteral on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


    };


    /**
     * \brief Computes the log10 of each pixel.
     *
     * This function directly calls the execute method of Log10ImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::Log10ImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Log10 ( const Image& image1 );

  }
}
#endif
