/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLevelSetMotionRegistrationFilter_h
#define sitkLevelSetMotionRegistrationFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class LevelSetMotionRegistrationFilter
\brief Deformably register two images using level set motion.

LevelSetMotionFilter implements a deformable registration algorithm that aligns a fixed and a moving image under level set motion. The equations of motion are similar to those of the DemonsRegistrationFilter . The main differences are: (1) Gradients of the moving image are calculated on a smoothed image while intensity difference are measured on the original images (2) Magnitude of the motion vector is a function of the differences in intensity between the fixed and moving pixel. An adaptive timestep is calculated based on the maximum motion vector over the entire field to ensure stability. The timestep also implictly converts the motion vector measured in units of intensity to a vector measured in physical units. Demons, on the other hand, defines its motion vectors as function of both the intensity differences and gradient magnitude at each respective pixel. Consider two separate pixels with the same intensity differences between the corresponding fixed and moving pixel pairs. In demons, the motion vector of the pixel over a low gradient region will be larger than the motion vector of the pixel over a large gradient region. This leads to an unstable vector field. In the levelset approach, the motion vectors will be proportional to the gradients, scaled by the maximum gradient over the entire field. The pixel with at the lower gradient position will more less than the pixel at the higher gradient position. (3) Gradients are calculated using minmod finite difference instead of using central differences.

A deformation field is represented as a image whose pixel type is some vector type with at least N elements, where N is the dimension of the fixed image. The vector type must support element access via operator []. It is assumed that the vector elements behave like floating point scalars.

This class is templated over the fixed image type, moving image type and the deformation field type.

The input fixed and moving images are set via methods SetFixedImage and SetMovingImage respectively. An initial deformation field maybe set via SetInitialDisplacementField or SetInput. If no initial field is set, a zero field is used as the initial condition.

The algorithm has one parameters: the number of iteration to be performed.

The output deformation field can be obtained via methods GetOutput or GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update for each iteration is computed in LevelSetMotionFunction.

\warning This filter assumes that the fixed image type, moving image type and deformation field type all have the same number of dimensions.

Ref: B.C. Vemuri, J. Ye, Y. Chen, C.M. Leonard. "Image registration via level-set motion: applications to atlas-based segmentation". Medical Image Analysis. Vol. 7. pp. 1-20. 2003.

\see LevelSetMotionRegistrationFunction 

\see DemonsRegistrationFilter

\sa itk::LevelSetMotionRegistrationFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LevelSetMotionRegistrationFilter : public ImageFilter<0> {
    public:
      typedef LevelSetMotionRegistrationFilter Self;

      /** Destructor */
      virtual ~LevelSetMotionRegistrationFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LevelSetMotionRegistrationFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get the standard deviation used for smoothing the moving image prior to calculating gradients. The standard deviation is measured in physical units (for instance mm). Note that this smoothing value is not to be confused with the PDEDeformableRegistrationFilter::SetStandardDeviations() method. The method in PDEDeformableRegistrationFilter is for setting the smoothing parameters for regularizing the deformation field between interations. Those smoothing parameters are set in pixel units not physical units. Deformation field smoothing is not done by default in LevelSetMotionRegistration. This smoothing parameter is to condition the gradient calculation and parameter is specified in physical units.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetGradientSmoothingStandardDeviations ( double GradientSmoothingStandardDeviations ) { this->m_GradientSmoothingStandardDeviations = GradientSmoothingStandardDeviations; return *this; }

      /**
       */
        double GetGradientSmoothingStandardDeviations() const { return this->m_GradientSmoothingStandardDeviations; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNumberOfIterations ( uint32_t NumberOfIterations ) { this->m_NumberOfIterations = NumberOfIterations; return *this; }

      /**
       */
        uint32_t GetNumberOfIterations() const { return this->m_NumberOfIterations; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaximumRMSError ( double MaximumRMSError ) { this->m_MaximumRMSError = MaximumRMSError; return *this; }

      /**
       */
        double GetMaximumRMSError() const { return this->m_MaximumRMSError; }

      /**
       * Set/Get the Gaussian smoothing standard deviations for the displacement field. The values are set with respect to pixel coordinates.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetStandardDeviations ( const std::vector<double> & StandardDeviations ) { this->m_StandardDeviations = StandardDeviations; return *this; }

      /** Set the values of the StandardDeviations vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetStandardDeviations( double value ) { this->m_StandardDeviations = std::vector<double>(3, value); return *this; }


      /**
       * Set/Get the Gaussian smoothing standard deviations for the displacement field. The values are set with respect to pixel coordinates.
       */
        std::vector<double> GetStandardDeviations() const { return this->m_StandardDeviations; }

      /**
       * Set/Get whether the displacement field is smoothed (regularized). Smoothing the displacement yields a solution elastic in nature. If SmoothDisplacementField is on, then the displacement field is smoothed with a Gaussian whose standard deviations are specified with SetStandardDeviations()
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSmoothDisplacementField ( bool SmoothDisplacementField ) { this->m_SmoothDisplacementField = SmoothDisplacementField; return *this; }

      /** Set the value of SmoothDisplacementField to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER SmoothDisplacementFieldOn() { return this->SetSmoothDisplacementField(true); }
      SITK_RETURN_SELF_TYPE_HEADER SmoothDisplacementFieldOff() { return this->SetSmoothDisplacementField(false); }

      /**
       * Set/Get whether the displacement field is smoothed (regularized). Smoothing the displacement yields a solution elastic in nature. If SmoothDisplacementField is on, then the displacement field is smoothed with a Gaussian whose standard deviations are specified with SetStandardDeviations()
       */
        bool GetSmoothDisplacementField() const { return this->m_SmoothDisplacementField; }

      /**
       * Set the Gaussian smoothing standard deviations for the update field. The values are set with respect to pixel coordinates.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpdateFieldStandardDeviations ( const std::vector<double> & UpdateFieldStandardDeviations ) { this->m_UpdateFieldStandardDeviations = UpdateFieldStandardDeviations; return *this; }

      /** Set the values of the UpdateFieldStandardDeviations vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetUpdateFieldStandardDeviations( double value ) { this->m_UpdateFieldStandardDeviations = std::vector<double>(3, value); return *this; }


      /**
       * Set the Gaussian smoothing standard deviations for the update field. The values are set with respect to pixel coordinates.
       */
        std::vector<double> GetUpdateFieldStandardDeviations() const { return this->m_UpdateFieldStandardDeviations; }

      /**
       * Set/Get whether the update field is smoothed (regularized). Smoothing the update field yields a solution viscous in nature. If SmoothUpdateField is on, then the update field is smoothed with a Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSmoothUpdateField ( bool SmoothUpdateField ) { this->m_SmoothUpdateField = SmoothUpdateField; return *this; }

      /** Set the value of SmoothUpdateField to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER SmoothUpdateFieldOn() { return this->SetSmoothUpdateField(true); }
      SITK_RETURN_SELF_TYPE_HEADER SmoothUpdateFieldOff() { return this->SetSmoothUpdateField(false); }

      /**
       * Set/Get whether the update field is smoothed (regularized). Smoothing the update field yields a solution viscous in nature. If SmoothUpdateField is on, then the update field is smoothed with a Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()
       */
        bool GetSmoothUpdateField() const { return this->m_SmoothUpdateField; }

      /**
       * Set/Get the desired limits of the Gaussian kernel width.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaximumKernelWidth ( unsigned int MaximumKernelWidth ) { this->m_MaximumKernelWidth = MaximumKernelWidth; return *this; }

      /**
       * Set/Get the desired limits of the Gaussian kernel width.
       */
        unsigned int GetMaximumKernelWidth() const { return this->m_MaximumKernelWidth; }

      /**
       * Set/Get the desired maximum error of the Guassian kernel approximate.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaximumError ( double MaximumError ) { this->m_MaximumError = MaximumError; return *this; }

      /**
       * Set/Get the desired maximum error of the Guassian kernel approximate.
       */
        double GetMaximumError() const { return this->m_MaximumError; }

      /**
       * Set/Get the parameter alpha. Alpha is added to the calculated gradient magnitude prior to normalizing the gradient to protect against numerical instability as the gradient magnitude approaches zero. This should be set as a small fraction of the intensity dynamic range, for instance 0.04%. Default is the absolute (not percentage) value of 0.1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAlpha ( double Alpha ) { this->m_Alpha = Alpha; return *this; }

      /**
       */
        double GetAlpha() const { return this->m_Alpha; }

      /**
       * Set/Get the threshold below which the absolute difference of intensity yields a match. When the intensities match between a moving and fixed image pixel, the update vector (for that iteration) will be the zero vector. Default is 0.001.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetIntensityDifferenceThreshold ( double IntensityDifferenceThreshold ) { this->m_IntensityDifferenceThreshold = IntensityDifferenceThreshold; return *this; }

      /**
       */
        double GetIntensityDifferenceThreshold() const { return this->m_IntensityDifferenceThreshold; }

      /**
       * Set/Get the threshold below which the gradient magnitude is considered the zero vector. Default is 1e-9.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetGradientMagnitudeThreshold ( double GradientMagnitudeThreshold ) { this->m_GradientMagnitudeThreshold = GradientMagnitudeThreshold; return *this; }

      /**
       */
        double GetGradientMagnitudeThreshold() const { return this->m_GradientMagnitudeThreshold; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       */
        bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }
     /** \brief Number of iterations run.
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     uint32_t GetElapsedIterations() const { return this->m_ElapsedIterations; };

     /** \brief The Root Mean Square of the levelset upon termination.
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetRMSChange() const { return this->m_RMSChange; };

     /**
      * Get the metric value. The metric value is the mean square difference in intensity between the fixed image and transforming moving image computed over the the overlapping region between the two images. This is value is only available for the previous iteration and NOT the current iteration.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetMetric() const { return this->m_Metric; };

      /** Name of this class */
      std::string GetName() const { return std::string ("LevelSetMotionRegistrationFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image & fixedImage, const Image & movingImage );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image & fixedImage, const Image & movingImage, double gradientSmoothingStandardDeviations, uint32_t numberOfIterations, double maximumRMSError, const std::vector<double> & standardDeviations, bool smoothDisplacementField, const std::vector<double> & updateFieldStandardDeviations, bool smoothUpdateField, unsigned int maximumKernelWidth, double maximumError, double alpha, double intensityDifferenceThreshold, double gradientMagnitudeThreshold, bool useImageSpacing );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image * fixedImage, const Image * movingImage );
      template <class TImageType> Image ExecuteInternal ( const Image * fixedImage, const Image * movingImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_GradientSmoothingStandardDeviations;
      /* Number of iterations to run */
      uint32_t  m_NumberOfIterations;
      /* Value of RMS change below which the filter should stop. This is a convergence criterion. */
      double  m_MaximumRMSError;
      std::vector<double>  m_StandardDeviations;
      bool  m_SmoothDisplacementField;
      std::vector<double>  m_UpdateFieldStandardDeviations;
      bool  m_SmoothUpdateField;
      unsigned int  m_MaximumKernelWidth;
      double  m_MaximumError;
      double  m_Alpha;
      double  m_IntensityDifferenceThreshold;
      double  m_GradientMagnitudeThreshold;
      bool  m_UseImageSpacing;

      uint32_t m_ElapsedIterations;

      double m_RMSChange;

      double m_Metric;

    };


  }
}
#endif
