/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLandmarkBasedTransformInitializerFilter_h
#define sitkLandmarkBasedTransformInitializerFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class LandmarkBasedTransformInitializerFilter


This class computes the transform that aligns the fixed and moving
images given a set of pair landmarks. The class is templated over the
Transform type as well as fixed image and moving image types. The
transform computed gives the best fit transform that maps the fixed
and moving images in a least squares sense. The indices are taken to
correspond, so point 1 in the first set will get mapped close to point
1 in the second set, etc.

Currently, the following transforms are supported by the class:
VersorRigid3DTransform Rigid2DTransform AffineTransform
BSplineTransform

An equal number of fixed and moving landmarks need to be specified
using SetFixedLandmarks() and SetMovingLandmarks() . Any number of
landmarks may be specified. In the case of using Affine or BSpline
transforms, each landmark pair can contribute in the final transform
based on its defined weight. Number of weights should be equal to the
number of landmarks and can be specified using SetLandmarkWeight()
. By defaults are weights are set to one. Call InitializeTransform()
to initialize the transform.

The class is based in part on Hybrid/vtkLandmarkTransform originally implemented in python by David G. Gobbi.

The solution is based on Berthold K. P. Horn (1987), "Closed-form solution of absolute orientation
using unit quaternions," http://people.csail.mit.edu/bkph/papers/Absolute_Orientation.pdf

The Affine Transform initializer is based on an algorithm by H Spaeth, and is described in the Insight Journal Article "Affine Transformation for Landmark Based Registration Initializer
in ITK" by Kim E.Y., Johnson H., Williams N. available at http://midasjournal.com/browse/publication/825

\par Wiki Examples:

\li All Examples

\li Rigidly register one image to another using manually specified landmarks
\sa itk::simple::LandmarkBasedTransformInitializerFilter for the procedural interface
\sa itk::LandmarkBasedTransformInitializer for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LandmarkBasedTransformInitializerFilter : public ImageFilter<0> {
    public:
      typedef LandmarkBasedTransformInitializerFilter Self;

      /** Destructor */
      virtual ~LandmarkBasedTransformInitializerFilter();


      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LandmarkBasedTransformInitializerFilter();

      /** Define the pixels types supported by this filter */
      typedef typelist::MakeTypeList<BasicPixelID<float> >::Type PixelIDTypeList;


      /**
       * Set the Fixed landmark point containers
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFixedLandmarks ( const std::vector<double> & FixedLandmarks ) { this->m_FixedLandmarks = FixedLandmarks; return *this; }

      /**
       *
       */
        std::vector<double> GetFixedLandmarks() const { return this->m_FixedLandmarks; }

      /**
       * Set the Moving landmark point containers
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMovingLandmarks ( const std::vector<double> & MovingLandmarks ) { this->m_MovingLandmarks = MovingLandmarks; return *this; }

      /**
       * Get the shrink factors.
       */
        std::vector<double> GetMovingLandmarks() const { return this->m_MovingLandmarks; }

      /**
       * Set the landmark weight point containers Weight includes diagonal elements of weight matrix
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLandmarkWeight ( const std::vector<double> & LandmarkWeight ) { this->m_LandmarkWeight = LandmarkWeight; return *this; }

      /**
       *
       */
      std::vector<double> GetLandmarkWeight() const { return this->m_LandmarkWeight; }

      /**
       * Set the reference image to define the parametric domain for the BSpline transform
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReferenceImage ( const Image & ReferenceImage ) { this->m_ReferenceImage = ReferenceImage; return *this; }

      /**
       */
        Image GetReferenceImage() const { return this->m_ReferenceImage; }

      /**
       * Set/Get the number of control points
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBSplineNumberOfControlPoints ( unsigned int BSplineNumberOfControlPoints ) { this->m_BSplineNumberOfControlPoints = BSplineNumberOfControlPoints; return *this; }

      /**
       * Set/Get the number of control points
       */
        unsigned int GetBSplineNumberOfControlPoints() const { return this->m_BSplineNumberOfControlPoints; }
      /** Name of this class */
      std::string GetName() const { return std::string ("LandmarkBasedTransformInitializerFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Transform Execute ( const Transform & transform );


      /** Execute the filter on the input image with the given parameters */
      Transform Execute ( const Transform & transform,
                          const std::vector<double> & fixedLandmarks,
                          const std::vector<double> & movingLandmarks,
                          const std::vector<double> & landmarkWeight,
                          const Image & referenceImage,
                          unsigned int numberOfControlPoints );


    private:

      /** Setup for member function dispatching */

      typedef Transform (Self::*MemberFunctionType)( const Transform * transform );
      template <class TImageType> Transform ExecuteInternal ( const Transform * transform );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<double>  m_FixedLandmarks;
      /*  */
      std::vector<double>  m_MovingLandmarks;
      /*  */
      std::vector<double>  m_LandmarkWeight;

      Image         m_ReferenceImage;
      unsigned int  m_BSplineNumberOfControlPoints;
    };


    /**
     * \brief itk::simple::LandmarkBasedTransformInitializerFilter Procedural Interface
     *
     * This function directly calls the execute method of LandmarkBasedTransformInitializerFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LandmarkBasedTransformInitializerFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Transform LandmarkBasedTransformInitializer ( const Transform & transform,
                                                                           const std::vector<double> & fixedLandmarks = std::vector<double>(),
                                                                           const std::vector<double> & movingLandmarks = std::vector<double>(),
                                                                           const std::vector<double> & landmarkWeight = std::vector<double>(),
                                                                           const Image & referenceImage = Image(),
                                                                           unsigned int numberOfControlPoints = 4u );

  }
}
#endif
