/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelVotingImageFilter_h
#define sitkLabelVotingImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkMultiInputImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

   /**\class LabelVotingImageFilter

\brief This filter performs pixelwise voting among an arbitrary number of input images, where each of them represents a segmentation of the same scene (i.e., image).

Label voting is a simple method of classifier combination applied to image segmentation. Typically, the accuracy of the combined segmentation exceeds the accuracy of any of the input segmentations. Voting is therefore commonly used as a way of boosting segmentation performance.

The use of label voting for combination of multiple segmentations is described in

T. Rohlfing and C. R. Maurer, Jr., "Multi-classifier framework for
atlas-based image segmentation," Pattern Recognition Letters, 2005.

\par INPUTS
All input volumes to this filter must be segmentations of an image, that is, they must have discrete pixel values where each value represents a different segmented object.

Input volumes must all contain the same size RequestedRegions. Not all input images must contain all possible labels, but all label values must have the same meaning in all images.

\par OUTPUTS
The voting filter produces a single output volume. Each output pixel contains the label that occurred most often among the labels assigned to this pixel in all the input volumes, that is, the label that received the maximum number of "votes" from the input pixels.. If the maximum number of votes is not unique, i.e., if more than one label have a maximum number of votes, an "undecided" label is assigned to that output pixel.

By default, the label used for undecided pixels is the maximum label value used in the input images plus one. Since it is possible for an image with 8 bit pixel values to use all 256 possible label values, it is permissible to combine 8 bit (i.e., byte) images into a 16 bit (i.e., short) output image.

\par PARAMETERS
The label used for "undecided" labels can be set using SetLabelForUndecidedPixels. This functionality can be unset by calling UnsetLabelForUndecidedPixels.

\author Torsten Rohlfing, SRI International, Neuroscience Program

\sa itk::simple::LabelVoting for the procedural interface
   */
    class SITKBasicFilters_EXPORT LabelVotingImageFilter
      : public ImageFilter<3>
    {
    public:
      typedef LabelVotingImageFilter Self;

      /** Destructor */
      virtual ~LabelVotingImageFilter();


      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelVotingImageFilter();

      /** Define the pixels types supported by this filter */
      typedef typelist::MakeTypeList< BasicPixelID<uint8_t>, BasicPixelID<uint16_t>, BasicPixelID<uint32_t>, BasicPixelID<uint64_t> >::Type  PixelIDTypeList;




      /**
       * Set label value for undecided pixels.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLabelForUndecidedPixels ( uint64_t LabelForUndecidedPixels ) { this->m_LabelForUndecidedPixels = LabelForUndecidedPixels; return *this; }

      /**
       * Get label value used for undecided pixels. After updating the filter, this function returns the actual label value used for undecided pixels in the current output. Note that this value is overwritten when SetLabelForUndecidedPixels is called and the new value only becomes effective upon the next filter update.
       */
        uint64_t GetLabelForUndecidedPixels() const { return this->m_LabelForUndecidedPixels; }
      /** Name of this class */
      std::string GetName() const { return std::string ("LabelVotingImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;

      /** Execute the filter on the input images */
      Image Execute ( const std::vector<Image> &images);
      Image Execute ( const Image& image1 );
      Image Execute ( const Image& image1, const Image& image2 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5 );



      /** Execute the filter on the input images with the given parameters */
      Image Execute ( const std::vector<Image> &images, uint64_t labelForUndecidedPixels );
      Image Execute ( const Image& image1, uint64_t labelForUndecidedPixels );
      Image Execute ( const Image& image1, const Image& image2, uint64_t labelForUndecidedPixels );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, uint64_t labelForUndecidedPixels );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, uint64_t labelForUndecidedPixels );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5, uint64_t labelForUndecidedPixels );




    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const std::vector<Image> & );
      template <class TImageType> Image ExecuteInternal ( const std::vector<Image> &images );



      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      uint64_t  m_LabelForUndecidedPixels;
    };


    /**
     * \brief This filter performs pixelwise voting among an arbitrary number of input images, where each of them represents a segmentation of the same scene (i.e., image).
     *
     * This function directly calls the execute method of LabelVotingImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelVotingImageFilter for the object oriented interface
     * @{
     */
     SITKBasicFilters_EXPORT Image LabelVoting ( const std::vector<Image> &images , uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max() );

     SITKBasicFilters_EXPORT Image LabelVoting ( const Image& image1, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max() );
     SITKBasicFilters_EXPORT Image LabelVoting ( const Image& image1, const Image& image2, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max() );
     SITKBasicFilters_EXPORT Image LabelVoting ( const Image& image1, const Image& image2, const Image& image3, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max() );
     SITKBasicFilters_EXPORT Image LabelVoting ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max() );
     SITKBasicFilters_EXPORT Image LabelVoting ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max() );

     /** @{ */

}
}
#endif
