/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelSetDilateImageFilter_h
#define sitkLabelSetDilateImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class LabelSetDilateImageFilter
\brief Class for binary morphological erosion of label images.

This filter is threaded.

\see itkLabelSetDilateErodeImageFilter

\author Richard Beare, Department of Medicine, Monash University, Australia. Richard.Beare@monash.edu
\sa itk::simple::LabelSetDilate for the procedural interface
\sa itk::LabelSetDilateImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelSetDilateImageFilter : public ImageFilter<1> {
    public:
      typedef LabelSetDilateImageFilter Self;

      /** Destructor */
      virtual ~LabelSetDilateImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelSetDilateImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;



      /**
       * Set the radius of the neighborhood used to compute the median.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius ( const std::vector<unsigned int> & Radius ) { this->m_Radius = Radius; return *this; }

      /** Set the values of the Radius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius( unsigned int value ) { this->m_Radius = std::vector<unsigned int>(3, value); return *this; }


      /**
       * Get the radius of the neighborhood used to compute the median
       */
        std::vector<unsigned int> GetRadius() const { return this->m_Radius; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       */
        bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }
      /** Name of this class */
      std::string GetName() const { return std::string ("LabelSetDilateImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector<unsigned int> & radius, bool useImageSpacing );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_Radius;
      bool  m_UseImageSpacing;
    };


    /**
     * \brief Class for binary morphological erosion of label images.
     *
     * This function directly calls the execute method of LabelSetDilateImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelSetDilateImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image LabelSetDilate ( const Image& image1, const std::vector<unsigned int> & radius = std::vector<unsigned int>(3, 1), bool useImageSpacing = true );

  }
}
#endif
