/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelOverlayImageFilter_h
#define sitkLabelOverlayImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkDualImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkDualMemberFunctionFactory.h"
#include "sitkBasicFilters.h"

namespace itk {
  namespace simple {

    /**\class LabelOverlayImageFilter
\brief Apply a colormap to a label image and put it on top of the input image.

Apply a colormap to a label image and put it on top of the input image. The set of colors is a good selection of distinct colors. The opacity of the label image can be defined by the user. The user can also choose if the want to use a background and which label value is the background. A background label produce a gray pixel with the same intensity than the input one.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

This class was contributed to the Insight Journal https://hdl.handle.net/1926/172 

\see LabelToRGBImageFilter 

\see LabelMapOverlayImageFilter , LabelOverlayFunctor
\sa itk::simple::LabelOverlay for the procedural interface
\sa itk::LabelOverlayImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelOverlayImageFilter : public ImageFilter<0> {
    public:
      typedef LabelOverlayImageFilter Self;

      /** Destructor */
      virtual ~LabelOverlayImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelOverlayImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get the opacity of the colored label image. The value must be between 0 and 1
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOpacity ( double Opacity ) { this->m_Opacity = Opacity; return *this; }

      /**
       * Set/Get the opacity of the colored label image. The value must be between 0 and 1
       */
        double GetOpacity() const { return this->m_Opacity; }

      /**
       * Set/Get the background value
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       * Set/Get the background value
       */
        double GetBackgroundValue() const { return this->m_BackgroundValue; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetColormap ( std::vector<uint8_t> Colormap ) { this->m_Colormap = Colormap; return *this; }

      /**
       */
        std::vector<uint8_t> GetColormap() const { return this->m_Colormap; }
      /** Name of this class */
      std::string GetName() const { return std::string ("LabelOverlayImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image & image, const Image & labelImage );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image & image, const Image & labelImage, double opacity, double backgroundValue, std::vector<uint8_t> colormap );


    private:
      /** Setup for member function dispatching */
      typedef Image (Self::*MemberFunctionType)( const Image * image, const Image * labelImage );

      friend struct detail::DualExecuteInternalAddressor<MemberFunctionType>;
      template <class TImageType1, class TImageType2> Image DualExecuteInternal ( const Image * image, const Image * labelImage );


      nsstd::auto_ptr<detail::DualMemberFunctionFactory<MemberFunctionType> > m_DualMemberFactory;



      /* Value assigned to pixels outside of the mask */
      double  m_Opacity;
      double  m_BackgroundValue;
      std::vector<uint8_t>  m_Colormap;
    };



    /**
     * \brief Apply a colormap to a label image and put it on top of the input image.
     *
     * This function directly calls the execute method of LabelOverlayImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelOverlayImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image LabelOverlay ( const Image & image, const Image & labelImage, double opacity = 0.5, double backgroundValue = 0.0, std::vector<uint8_t> colormap = std::vector<uint8_t>() );

  }
}
#endif
