/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelOverlapMeasuresImageFilter_h
#define sitkLabelOverlapMeasuresImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class LabelOverlapMeasuresImageFilter
\brief Computes overlap measures between the set same set of labels of pixels of two images. Background is assumed to be 0.

This code was contributed in the Insight Journal paper: "Introducing Dice, Jaccard, and Other Label Overlap Measures To ITK" by Nicholas J. Tustison, James C. Gee https://hdl.handle.net/10380/3141 http://www.insight-journal.org/browse/publication/707 

\author Nicholas J. Tustison 

\see LabelOverlapMeasuresImageFilter

\sa itk::LabelOverlapMeasuresImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelOverlapMeasuresImageFilter : public ImageFilter<2> {
    public:
      typedef LabelOverlapMeasuresImageFilter Self;

      /** Destructor */
      virtual ~LabelOverlapMeasuresImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelOverlapMeasuresImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;


     /**
      * Get the false negative error for the specified individual label.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetFalseNegativeError() const { return this->m_FalseNegativeError; };

     /**
      * Get the false positive error for the specified individual label.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetFalsePositiveError() const { return this->m_FalsePositiveError; };

     /**
      * Get the mean overlap (Dice coefficient) for the specified individual label.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetMeanOverlap() const { return this->m_MeanOverlap; };

     /**
      * Get the union overlap (Jaccard coefficient) for the specified individual label.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetUnionOverlap() const { return this->m_UnionOverlap; };

     /**
      * Get the volume similarity for the specified individual label.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetVolumeSimilarity() const { return this->m_VolumeSimilarity; };

     /**
      * Get the union overlap (Jaccard coefficient) for the specified individual label.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetJaccardCoefficient() const { return this->m_JaccardCoefficient; };

     /**
      * Get the mean overlap (Dice coefficient) for the specified individual label.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetDiceCoefficient() const { return this->m_DiceCoefficient; };

      /** Name of this class */
      std::string GetName() const { return std::string ("LabelOverlapMeasuresImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      void Execute ( const Image& image1, const Image& image2 );


    private:

      /** Setup for member function dispatching */

      typedef void (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> void ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



      double m_FalseNegativeError;

      double m_FalsePositiveError;

      double m_MeanOverlap;

      double m_UnionOverlap;

      double m_VolumeSimilarity;

      double m_JaccardCoefficient;

      double m_DiceCoefficient;

    };


  }
}
#endif
