/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelMapToRGBImageFilter_h
#define sitkLabelMapToRGBImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class LabelMapToRGBImageFilter
\brief Convert a LabelMap to a colored image.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176 

\see LabelToRGBImageFilter , LabelToRGBFunctor 

\see LabelMapOverlayImageFilter , LabelMapToBinaryImageFilter , LabelMapMaskImageFilter
\sa itk::simple::LabelMapToRGB for the procedural interface
\sa itk::LabelMapToRGBImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelMapToRGBImageFilter : public ImageFilter<1> {
    public:
      typedef LabelMapToRGBImageFilter Self;

      /** Destructor */
      virtual ~LabelMapToRGBImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelMapToRGBImageFilter();

      /** Define the pixels types supported by this filter */
      typedef LabelPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetColormap ( std::vector<uint8_t> Colormap ) { this->m_Colormap = Colormap; return *this; }

      /**
       */
        std::vector<uint8_t> GetColormap() const { return this->m_Colormap; }
      /** Name of this class */
      std::string GetName() const { return std::string ("LabelMapToRGBImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, std::vector<uint8_t> colormap );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<uint8_t>  m_Colormap;
    };


    /**
     * \brief Convert a LabelMap to a colored image.
     *
     * This function directly calls the execute method of LabelMapToRGBImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelMapToRGBImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image LabelMapToRGB ( const Image& image1, std::vector<uint8_t> colormap = std::vector<uint8_t>() );

  }
}
#endif
