/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkIsoContourDistanceImageFilter_h
#define sitkIsoContourDistanceImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class IsoContourDistanceImageFilter
\brief Compute an approximate distance from an interpolated isocontour to the close grid points.

For standard level set algorithms, it is useful to periodically reinitialize the evolving image to prevent numerical accuracy problems in computing derivatives. This reinitialization is done by computing a signed distance map to the current level set. This class provides the first step in this reinitialization by computing an estimate of the distance from the interpolated isocontour to the pixels (or voxels) that are close to it, i.e. for which the isocontour crosses a segment between them and one of their direct neighbors. This class supports narrowbanding. If the input narrowband is provided, the algorithm will only locate the level set within the input narrowband.

Implementation of this class is based on Fast and Accurate Redistancing for Level Set Methods `Krissian K. and Westin C.F.', EUROCAST NeuroImaging Workshop Las Palmas Spain, Ninth International Conference on Computer Aided Systems Theory , pages 48-51, Feb 2003.
\sa itk::simple::IsoContourDistance for the procedural interface
\sa itk::IsoContourDistanceImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT IsoContourDistanceImageFilter : public ImageFilter<1> {
    public:
      typedef IsoContourDistanceImageFilter Self;

      /** Destructor */
      virtual ~IsoContourDistanceImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      IsoContourDistanceImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get the value of the level set to be located. The default value is 0.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLevelSetValue ( double LevelSetValue ) { this->m_LevelSetValue = LevelSetValue; return *this; }

      /**
       * Set/Get the value of the level set to be located. The default value is 0.
       */
        double GetLevelSetValue() const { return this->m_LevelSetValue; }

      /**
       * Set/Get the value of the level set to be located. The default value is 0.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFarValue ( double FarValue ) { this->m_FarValue = FarValue; return *this; }

      /**
       * Set/Get the value of the level set to be located. The default value is 0.
       */
        double GetFarValue() const { return this->m_FarValue; }
      /** Name of this class */
      std::string GetName() const { return std::string ("IsoContourDistanceImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double levelSetValue, double farValue );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_LevelSetValue;
      double  m_FarValue;
    };


    /**
     * \brief Compute an approximate distance from an interpolated isocontour to the close grid points.
     *
     * This function directly calls the execute method of IsoContourDistanceImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::IsoContourDistanceImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image IsoContourDistance ( const Image& image1, double levelSetValue = 0.0, double farValue = 10 );

  }
}
#endif
