/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkInverseFFTImageFilter_h
#define sitkInverseFFTImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class InverseFFTImageFilter
\brief Base class for inverse Fast Fourier Transform .

This is a base class for the "inverse" or "reverse" Discrete Fourier Transform . This is an abstract base class: the actual implementation is provided by the best child available on the system when the object is created via the object factory system.

This class transforms a full complex image with Hermitian symmetry into its real spatial domain representation. If the input does not have Hermitian symmetry, the imaginary component is discarded.

\see ForwardFFTImageFilter , InverseFFTImageFilter
\sa itk::simple::InverseFFT for the procedural interface
\sa itk::InverseFFTImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT InverseFFTImageFilter : public ImageFilter<1> {
    public:
      typedef InverseFFTImageFilter Self;

      /** Destructor */
      virtual ~InverseFFTImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      InverseFFTImageFilter();

      /** Define the pixels types supported by this filter */
      typedef ComplexPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("InverseFFTImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


    };


    /**
     * \brief Base class for inverse Fast Fourier Transform .
     *
     * This function directly calls the execute method of InverseFFTImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::InverseFFTImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image InverseFFT ( const Image& image1 );

  }
}
#endif
