/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkInverseDisplacementFieldImageFilter_h
#define sitkInverseDisplacementFieldImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class InverseDisplacementFieldImageFilter
\brief Computes the inverse of a displacement field.

InverseDisplacementFieldImageFilter takes a displacement field as input and computes the displacement field that is its inverse. If the input displacement field was mapping coordinates from a space A into a space B, the output of this filter will map coordinates from the space B into the space A.

Given that both the input and output displacement field are represented as discrete images with pixel type vector, the inverse will be only an estimation and will probably not correspond to a perfect inverse. The precision of the inverse can be improved at the price of increasing the computation time and memory consumption in this filter.

The method used for computing the inverse displacement field is to subsample the input field using a regular grid and create Kerned-Base Spline in which the reference landmarks are the coordinates of the deformed point and the target landmarks are the negative of the displacement vectors. The kernel-base spline is then used for regularly sampling the output space and recover vector values for every single pixel.

The subsampling factor used for the regular grid of the input field will determine the number of landmarks in the KernelBased spline and therefore it will have a dramatic effect on both the precision of output displacement field and the computational time required for the filter to complete the estimation. A large subsampling factor will result in few landmarks in the KernelBased spline, therefore on fast computation and low precision. A small subsampling factor will result in a large number of landmarks in the KernelBased spline, therefore a large memory consumption, long computation time and high precision for the inverse estimation.

This filter expects both the input and output images to be of pixel type Vector .
\sa itk::simple::InverseDisplacementField for the procedural interface
\sa itk::InverseDisplacementFieldImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT InverseDisplacementFieldImageFilter : public ImageFilter<1> {
    public:
      typedef InverseDisplacementFieldImageFilter Self;

      /** Destructor */
      virtual ~InverseDisplacementFieldImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      InverseDisplacementFieldImageFilter();

      /** Define the pixels types supported by this filter */
      typedef RealVectorPixelIDTypeList  PixelIDTypeList;



      /**
       * Set the size of the output image.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSize ( const std::vector<uint32_t> & Size ) { this->m_Size = Size; return *this; }

      /**
       * Get the size of the output image.
       */
        std::vector<uint32_t> GetSize() const { return this->m_Size; }

      /**
       * Set the output image origin.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputOrigin ( const std::vector<double> & OutputOrigin ) { this->m_OutputOrigin = OutputOrigin; return *this; }

      /**
       * Get the output image origin.
       */
        std::vector<double> GetOutputOrigin() const { return this->m_OutputOrigin; }

      /**
       * Set the output image spacing.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputSpacing ( const std::vector<double> & OutputSpacing ) { this->m_OutputSpacing = OutputSpacing; return *this; }

      /**
       * Get the output image spacing.
       */
        std::vector<double> GetOutputSpacing() const { return this->m_OutputSpacing; }

      /**
       * Set/Get the factor used for subsampling the input displacement field. A large value in this factor will produce a fast computation of the inverse field but with low precision. A small value of this factor will produce a precise computation of the inverse field at the price of large memory consumption and long computational time.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSubsamplingFactor ( unsigned int SubsamplingFactor ) { this->m_SubsamplingFactor = SubsamplingFactor; return *this; }

      /**
       * Set/Get the factor used for subsampling the input displacement field. A large value in this factor will produce a fast computation of the inverse field but with low precision. A small value of this factor will produce a precise computation of the inverse field at the price of large memory consumption and long computational time.
       */
        unsigned int GetSubsamplingFactor() const { return this->m_SubsamplingFactor; }
      /** Name of this class */
      std::string GetName() const { return std::string ("InverseDisplacementFieldImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector<uint32_t> & size, const std::vector<double> & outputOrigin, const std::vector<double> & outputSpacing, unsigned int subsamplingFactor );


      /** This methods sets the output size, origin, and direction to that of the provided image */
      void SetReferenceImage(const Image & refImage );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<uint32_t>  m_Size;
      /*  */
      std::vector<double>  m_OutputOrigin;
      /*  */
      std::vector<double>  m_OutputSpacing;
      unsigned int  m_SubsamplingFactor;

    };


    /**
     * \brief Computes the inverse of a displacement field.
     *
     * This function directly calls the execute method of InverseDisplacementFieldImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::InverseDisplacementFieldImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image InverseDisplacementField ( const Image& image1, const std::vector<uint32_t> & size = std::vector<uint32_t>(3, 0), const std::vector<double> & outputOrigin = std::vector<double>(3, 0.0), const std::vector<double> & outputSpacing = std::vector<double>(3, 1.0), unsigned int subsamplingFactor = 16u );

  }
}
#endif
