/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkInverseDeconvolutionImageFilter_h
#define sitkInverseDeconvolutionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class InverseDeconvolutionImageFilter
\brief The direct linear inverse deconvolution filter.

The inverse filter is the most straightforward deconvolution method. Considering that convolution of two images in the spatial domain is equivalent to multiplying the Fourier transform of the two images, the inverse filter consists of inverting the multiplication. In other words, this filter computes the following: \f[ hat{F}(\omega) = \begin{cases} G(\omega) / H(\omega) & \text{if \f$|H(\omega)| \geq \epsilon\f$} \\ 0 & \text{otherwise} \end{cases} \f] where \f$\hat{F}(\omega)\f$ is the Fourier transform of the estimate produced by this filter, \f$G(\omega)\f$ is the Fourier transform of the input blurred image, \f$H(\omega)\f$ is the Fourier transform of the blurring kernel, and \f$\epsilon\f$ is a constant real non-negative threshold (called KernelZeroMagnitudeThreshold in this filter) that determines when the magnitude of a complex number is considered zero.

\author Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France 

\author Cory Quammen, The University of North Carolina at Chapel Hill
\sa itk::simple::InverseDeconvolution for the procedural interface
\sa itk::InverseDeconvolutionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT InverseDeconvolutionImageFilter : public ImageFilter<2> {
    public:
      typedef InverseDeconvolutionImageFilter Self;

      /** Destructor */
      virtual ~InverseDeconvolutionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      InverseDeconvolutionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/get the threshold value uused to determine whether a frequency of the Fourier transform of the blurring kernel is considered to be zero. Default value is 1.0e-4.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelZeroMagnitudeThreshold ( double KernelZeroMagnitudeThreshold ) { this->m_KernelZeroMagnitudeThreshold = KernelZeroMagnitudeThreshold; return *this; }

      /**
       * Set/get the threshold value uused to determine whether a frequency of the Fourier transform of the blurring kernel is considered to be zero. Default value is 1.0e-4.
       */
        double GetKernelZeroMagnitudeThreshold() const { return this->m_KernelZeroMagnitudeThreshold; }

      /**
       * Normalize the output image by the sum of the kernel components

       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalize ( bool Normalize ) { this->m_Normalize = Normalize; return *this; }

      /** Set the value of Normalize to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOn() { return this->SetNormalize(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOff() { return this->SetNormalize(false); }

      /**
       */
        bool GetNormalize() const { return this->m_Normalize; }

      typedef enum {ZERO_PAD,ZERO_FLUX_NEUMANN_PAD,PERIODIC_PAD} BoundaryConditionType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBoundaryCondition ( BoundaryConditionType BoundaryCondition ) { this->m_BoundaryCondition = BoundaryCondition; return *this; }

      /**
       */
        BoundaryConditionType GetBoundaryCondition() const { return this->m_BoundaryCondition; }

      typedef enum {SAME,VALID} OutputRegionModeType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputRegionMode ( OutputRegionModeType OutputRegionMode ) { this->m_OutputRegionMode = OutputRegionMode; return *this; }

      /**
       */
        OutputRegionModeType GetOutputRegionMode() const { return this->m_OutputRegionMode; }
      /** Name of this class */
      std::string GetName() const { return std::string ("InverseDeconvolutionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter on the input images with the given parameters */
      Image Execute ( const Image& image1, const Image& image2, double kernelZeroMagnitudeThreshold, bool normalize, InverseDeconvolutionImageFilter::BoundaryConditionType boundaryCondition, InverseDeconvolutionImageFilter::OutputRegionModeType outputRegionMode );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_KernelZeroMagnitudeThreshold;
      /*  */
      bool  m_Normalize;
      BoundaryConditionType  m_BoundaryCondition;
      OutputRegionModeType  m_OutputRegionMode;
    };


    /**
     * \brief The direct linear inverse deconvolution filter.
     *
     * This function directly calls the execute method of InverseDeconvolutionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::InverseDeconvolutionImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image InverseDeconvolution ( const Image& image1, const Image& image2, double kernelZeroMagnitudeThreshold = 1.0e-4, bool normalize = false, InverseDeconvolutionImageFilter::BoundaryConditionType boundaryCondition = itk::simple::InverseDeconvolutionImageFilter::ZERO_FLUX_NEUMANN_PAD, InverseDeconvolutionImageFilter::OutputRegionModeType outputRegionMode = itk::simple::InverseDeconvolutionImageFilter::SAME );

  }
}
#endif
