/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkHalfHermitianToRealInverseFFTImageFilter_h
#define sitkHalfHermitianToRealInverseFFTImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class HalfHermitianToRealInverseFFTImageFilter
\brief Base class for specialized complex-to-real inverse Fast Fourier Transform .

This is a base class for the "inverse" or "reverse" Discrete Fourier Transform . This is an abstract base class: the actual implementation is provided by the best child class available on the system when the object is created via the object factory system.

The input to this filter is assumed to have the same format as the output of the RealToHalfHermitianForwardFFTImageFilter . That is, the input is assumed to consist of roughly half the full complex image resulting from a real-to-complex discrete Fourier transform. This half is expected to be the first half of the image in the X-dimension. Because this filter assumes that the input stores only about half of the non-redundant complex pixels, the output is larger in the X-dimension than it is in the input. To determine the actual size of the output image, this filter needs additional information in the form of a flag indicating whether the output image has an odd size in the X-dimension. Use SetActualXDimensionIsOdd() to set this flag.

\see ForwardFFTImageFilter , HalfHermitianToRealInverseFFTImageFilter
\sa itk::simple::HalfHermitianToRealInverseFFT for the procedural interface
\sa itk::HalfHermitianToRealInverseFFTImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT HalfHermitianToRealInverseFFTImageFilter : public ImageFilter<1> {
    public:
      typedef HalfHermitianToRealInverseFFTImageFilter Self;

      /** Destructor */
      virtual ~HalfHermitianToRealInverseFFTImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      HalfHermitianToRealInverseFFTImageFilter();

      /** Define the pixels types supported by this filter */
      typedef ComplexPixelIDTypeList  PixelIDTypeList;



      /**
       * Was the original truncated dimension size odd?
       */
      SITK_RETURN_SELF_TYPE_HEADER SetActualXDimensionIsOdd ( bool ActualXDimensionIsOdd ) { this->m_ActualXDimensionIsOdd = ActualXDimensionIsOdd; return *this; }

      /** Set the value of ActualXDimensionIsOdd to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER ActualXDimensionIsOddOn() { return this->SetActualXDimensionIsOdd(true); }
      SITK_RETURN_SELF_TYPE_HEADER ActualXDimensionIsOddOff() { return this->SetActualXDimensionIsOdd(false); }

      /**
       * Was the original truncated dimension size odd?
       */
        bool GetActualXDimensionIsOdd() const { return this->m_ActualXDimensionIsOdd; }
      /** Name of this class */
      std::string GetName() const { return std::string ("HalfHermitianToRealInverseFFTImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, bool actualXDimensionIsOdd );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_ActualXDimensionIsOdd;
    };


    /**
     * \brief Base class for specialized complex-to-real inverse Fast Fourier Transform .
     *
     * This function directly calls the execute method of HalfHermitianToRealInverseFFTImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::HalfHermitianToRealInverseFFTImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image HalfHermitianToRealInverseFFT ( const Image& image1, bool actualXDimensionIsOdd = false );

  }
}
#endif
