/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGridImageSource_h
#define sitkGridImageSource_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageSourceTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class GridImageSource
\brief Generate an n-dimensional image of a grid.

GridImageSource generates an image of a grid. From the abstract... "Certain classes of images find disparate use amongst members of the ITK community for such purposes as visualization, simulation, testing, etc. Currently there exists two derived classes from the ImageSource class used for generating specific images for various applications, viz. RandomImageSource and GaussianImageSource . We propose to add to this set with the class GridImageSource which, obviously enough, produces a grid image. Such images are useful for visualizing deformation when used in conjunction with the WarpImageFilter , simulating magnetic resonance tagging images, or creating optical illusions with which to amaze your friends."

The output image may be of any dimension.

\author Tustison N., Avants B., Gee J. University of Pennsylvania

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/475
\sa itk::simple::GridSource for the procedural interface
\sa itk::GridImageSource for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GridImageSource : public ImageFilter<0> {
    public:
      typedef GridImageSource Self;

      /** Destructor */
      virtual ~GridImageSource();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GridImageSource();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;





      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputPixelType ( PixelIDValueEnum OutputPixelType ) { this->m_OutputPixelType = OutputPixelType; return *this; }

      /**
       */
        PixelIDValueEnum GetOutputPixelType() const { return this->m_OutputPixelType; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSize ( const std::vector<unsigned int> & Size ) { this->m_Size = Size; return *this; }

      /**
       */
        std::vector<unsigned int> GetSize() const { return this->m_Size; }

      /**
       * Set/Get the standard deviation of the Gaussians or width of the box functions.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma ( const std::vector<double> & Sigma ) { this->m_Sigma = Sigma; return *this; }

      /** Set the values of the Sigma vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma( double value ) { this->m_Sigma = std::vector<double>(3, value); return *this; }


      /**
       * Set/Get the standard deviation of the Gaussians or width of the box functions.
       */
        std::vector<double> GetSigma() const { return this->m_Sigma; }

      /**
       * Set/Get the grid spacing of the peaks.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetGridSpacing ( const std::vector<double> & GridSpacing ) { this->m_GridSpacing = GridSpacing; return *this; }

      /**
       * Set/Get the grid spacing of the peaks.
       */
        std::vector<double> GetGridSpacing() const { return this->m_GridSpacing; }

      /**
       * Set/Get the grid offset.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetGridOffset ( const std::vector<double> & GridOffset ) { this->m_GridOffset = GridOffset; return *this; }

      /**
       * Set/Get the grid offset.
       */
        std::vector<double> GetGridOffset() const { return this->m_GridOffset; }

      /**
       * Set/Get the scale factor to multiply the true value of the grid.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetScale ( double Scale ) { this->m_Scale = Scale; return *this; }

      /**
       * Set/Get the scale factor to multiply the true value of the grid.
       */
        double GetScale() const { return this->m_Scale; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOrigin ( const std::vector<double> & Origin ) { this->m_Origin = Origin; return *this; }

      /**
       */
        std::vector<double> GetOrigin() const { return this->m_Origin; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSpacing ( const std::vector<double> & Spacing ) { this->m_Spacing = Spacing; return *this; }

      /**
       */
        std::vector<double> GetSpacing() const { return this->m_Spacing; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDirection ( std::vector<double> Direction ) { this->m_Direction = Direction; return *this; }

      /**
       */
        std::vector<double> GetDirection() const { return this->m_Direction; }
      /** Name of this class */
      std::string GetName() const { return std::string ("GridImageSource"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute (  );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( PixelIDValueEnum outputPixelType, const std::vector<unsigned int> & size, const std::vector<double> & sigma, const std::vector<double> & gridSpacing, const std::vector<double> & gridOffset, double scale, const std::vector<double> & origin, const std::vector<double> & spacing, std::vector<double> direction );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)(  );
      template <class TImageType> Image ExecuteInternal (  );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      PixelIDValueEnum  m_OutputPixelType;
      std::vector<unsigned int>  m_Size;
      std::vector<double>  m_Sigma;
      std::vector<double>  m_GridSpacing;
      std::vector<double>  m_GridOffset;
      double  m_Scale;
      std::vector<double>  m_Origin;
      std::vector<double>  m_Spacing;
      /* Passing a zero sized array, defaults to identiy matrix. The size of the array must exactly match the direction matrix for the dimension of the image. */
      std::vector<double>  m_Direction;



    };



   /**
     * \brief Generate an n-dimensional image of a grid.
     *
     * This function directly calls the execute method of GridImageSource
     * in order to support a procedural API
     *
     * \sa itk::simple::GridImageSource for the object oriented interface
     */
SITKBasicFilters_EXPORT Image GridSource ( PixelIDValueEnum outputPixelType = itk::simple::sitkFloat32, const std::vector<unsigned int> & size = std::vector<unsigned int>(3, 64), const std::vector<double> & sigma = std::vector<double>(3, 0.5), const std::vector<double> & gridSpacing = std::vector<double>(3, 4.0), const std::vector<double> & gridOffset = std::vector<double>(3, 0.0), double scale = 255.0, const std::vector<double> & origin = std::vector<double>(3, 0.0), const std::vector<double> & spacing = std::vector<double>(3, 1.0), std::vector<double> direction = std::vector<double>() );
  }
}
#endif
