/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGrayscaleErodeImageFilter_h
#define sitkGrayscaleErodeImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkKernelImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkBasicFilters.h"
#include "sitkKernel.h"

namespace itk {
  namespace simple {

    /**\class GrayscaleErodeImageFilter
\brief Grayscale erosion of an image.

Erode an image using grayscale morphology. Erosion takes the maximum of all the pixels identified by the structuring element.

The structuring element is assumed to be composed of binary values (zero or one). Only elements of the structuring element having values > 0 are candidates for affecting the center pixel.

\see MorphologyImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter
\sa itk::simple::GrayscaleErode for the procedural interface
\sa itk::GrayscaleErodeImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GrayscaleErodeImageFilter : public ImageFilter<1> {
    public:
      typedef GrayscaleErodeImageFilter Self;

      /** Destructor */
      virtual ~GrayscaleErodeImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GrayscaleErodeImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;

    /** Kernel type enumeration */
    typedef enum{Annulus=sitkAnnulus, Ball=sitkBall, Box=sitkBox, Cross=sitkCross} KernelType;


      /** Kernel radius as a scale for isotropic structures */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(uint32_t r);

      /** Set/Get the radius of the kernel structuring element as a
       * vector.
       *
       * If the dimension of the image is greater then the length of
       * r, then the radius will be padded. If it is less the r will
       * be truncated.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(const std::vector<uint32_t>  &r );
      std::vector<uint32_t> GetKernelRadius() const;

      /** Set/Get the kernel or structuring elemenent used for the
       * morphology */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelEnum t);
#ifndef SWIG
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelType t);
#endif
      KernelEnum GetKernelType() const;

      /** Name of this class */
      std::string GetName() const { return std::string ("GrayscaleErodeImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );



    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



      /* Kernel Radius as a vector */
      std::vector<uint32_t> m_KernelRadius;

      /** KernelType */
      KernelEnum m_KernelType;
    };


    /**
     * itk::simple::GrayscaleErodeImageFilter Functional Interface
     *
     * This function directly calls the execute method of GrayscaleErodeImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT GrayscaleErode ( const Image&,
                                          uint32_t radius = 1, KernelEnum kernel = sitkBall
                                           );


   /**
     * itk::simple::GrayscaleErodeImageFilter Functional Interface
     *
     * This function directly calls the execute method of GrayscaleErodeImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT GrayscaleErode ( const Image&,
                                          const std::vector<uint32_t> vectorRadius, KernelEnum kernel = sitkBall
                                           );
  }
}
#endif
