/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGradientRecursiveGaussianImageFilter_h
#define sitkGradientRecursiveGaussianImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class GradientRecursiveGaussianImageFilter
\brief Computes the gradient of an image by convolution with the first derivative of a Gaussian.

This filter is implemented using the recursive gaussian filters.

This filter supports both scalar and vector pixel types within the input image, including VectorImage type.
\sa itk::simple::GradientRecursiveGaussian for the procedural interface
\sa itk::GradientRecursiveGaussianImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GradientRecursiveGaussianImageFilter : public ImageFilter<1> {
    public:
      typedef GradientRecursiveGaussianImageFilter Self;

      /** Destructor */
      virtual ~GradientRecursiveGaussianImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GradientRecursiveGaussianImageFilter();

      /** Define the pixels types supported by this filter */
      typedef typelist::Append<BasicPixelIDTypeList, VectorPixelIDTypeList>::Type  PixelIDTypeList;



      /**
       * Set Sigma value. Sigma is measured in the units of image spacing.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma ( double Sigma ) { this->m_Sigma = Sigma; return *this; }

      /**
       */
        double GetSigma() const { return this->m_Sigma; }

      /**
       * Define which normalization factor will be used for the Gaussian \see RecursiveGaussianImageFilter::SetNormalizeAcrossScale
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalizeAcrossScale ( bool NormalizeAcrossScale ) { this->m_NormalizeAcrossScale = NormalizeAcrossScale; return *this; }

      /** Set the value of NormalizeAcrossScale to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeAcrossScaleOn() { return this->SetNormalizeAcrossScale(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeAcrossScaleOff() { return this->SetNormalizeAcrossScale(false); }

      /**
       * Define which normalization factor will be used for the Gaussian \see RecursiveGaussianImageFilter::SetNormalizeAcrossScale
       */
        bool GetNormalizeAcrossScale() const { return this->m_NormalizeAcrossScale; }

      /**
       * The UseImageDirection flag determines whether the gradients are computed with respect to the image grid or with respect to the physical space. When this flag is ON the gradients are computed with respect to the coordinate system of physical space. The difference is whether we take into account the image Direction or not. The flag ON will take into account the image direction and will result in an extra matrix multiplication compared to the amount of computation performed when the flag is OFF. The default value of this flag is On.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageDirection ( bool UseImageDirection ) { this->m_UseImageDirection = UseImageDirection; return *this; }

      /** Set the value of UseImageDirection to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageDirectionOn() { return this->SetUseImageDirection(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageDirectionOff() { return this->SetUseImageDirection(false); }

      /**
       * The UseImageDirection flag determines whether the gradients are computed with respect to the image grid or with respect to the physical space. When this flag is ON the gradients are computed with respect to the coordinate system of physical space. The difference is whether we take into account the image Direction or not. The flag ON will take into account the image direction and will result in an extra matrix multiplication compared to the amount of computation performed when the flag is OFF. The default value of this flag is On.
       */
        bool GetUseImageDirection() const { return this->m_UseImageDirection; }
      /** Name of this class */
      std::string GetName() const { return std::string ("GradientRecursiveGaussianImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double sigma, bool normalizeAcrossScale, bool useImageDirection );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      double  m_Sigma;
      /*  */
      bool  m_NormalizeAcrossScale;
      bool  m_UseImageDirection;
    };


    /**
     * \brief Computes the gradient of an image by convolution with the first derivative of a Gaussian.
     *
     * This function directly calls the execute method of GradientRecursiveGaussianImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::GradientRecursiveGaussianImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image GradientRecursiveGaussian ( const Image& image1, double sigma = 1.0, bool normalizeAcrossScale = false, bool useImageDirection = false );

  }
}
#endif
