/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGradientMagnitudeImageFilter_h
#define sitkGradientMagnitudeImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class GradientMagnitudeImageFilter
\brief Computes the gradient magnitude of an image region at each pixel.

\see Image 

\see Neighborhood 

\see NeighborhoodOperator 

\see NeighborhoodIterator
\sa itk::simple::GradientMagnitude for the procedural interface
\sa itk::GradientMagnitudeImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GradientMagnitudeImageFilter : public ImageFilter<1> {
    public:
      typedef GradientMagnitudeImageFilter Self;

      /** Destructor */
      virtual ~GradientMagnitudeImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GradientMagnitudeImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get whether or not the filter will use the spacing of the input image in its calculations
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       * Set/Get whether or not the filter will use the spacing of the input image in its calculations
       */
        bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }
      /** Name of this class */
      std::string GetName() const { return std::string ("GradientMagnitudeImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, bool useImageSpacing );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      bool  m_UseImageSpacing;
    };


    /**
     * \brief Computes the gradient magnitude of an image region at each pixel.
     *
     * This function directly calls the execute method of GradientMagnitudeImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::GradientMagnitudeImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image GradientMagnitude ( const Image& image1, bool useImageSpacing = true );

  }
}
#endif
