/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGradientImageFilter_h
#define sitkGradientImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class GradientImageFilter
\brief Computes the gradient of an image using directional derivatives.

Computes the gradient of an image using directional derivatives. The directional derivative at each pixel location is computed by convolution with a first-order derivative operator.

The second template parameter defines the value type used in the derivative operator (defaults to float). The third template parameter defines the value type used for output image (defaults to float). The output image is defined as a covariant vector image whose value type is specified as this third template parameter.

\see Image 

\see Neighborhood 

\see NeighborhoodOperator 

\see NeighborhoodIterator
\sa itk::simple::Gradient for the procedural interface
\sa itk::GradientImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GradientImageFilter : public ImageFilter<1> {
    public:
      typedef GradientImageFilter Self;

      /** Destructor */
      virtual ~GradientImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GradientImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get whether or not the filter will use the spacing of the input image in its calculations
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       */
        bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }

      /**
       * The UseImageDirection flag determines whether image derivatives are computed with respect to the image grid or with respect to the physical space. When this flag is ON the derivatives are computed with respect to the coordinate system of physical space. The difference is whether we take into account the image Direction or not. The flag ON will take into account the image direction and will result in an extra matrix multiplication compared to the amount of computation performed when the flag is OFF. The default value of this flag is On.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageDirection ( bool UseImageDirection ) { this->m_UseImageDirection = UseImageDirection; return *this; }

      /** Set the value of UseImageDirection to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageDirectionOn() { return this->SetUseImageDirection(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageDirectionOff() { return this->SetUseImageDirection(false); }

      /**
       * The UseImageDirection flag determines whether image derivatives are computed with respect to the image grid or with respect to the physical space. When this flag is ON the derivatives are computed with respect to the coordinate system of physical space. The difference is whether we take into account the image Direction or not. The flag ON will take into account the image direction and will result in an extra matrix multiplication compared to the amount of computation performed when the flag is OFF. The default value of this flag is On.
       */
        bool GetUseImageDirection() const { return this->m_UseImageDirection; }
      /** Name of this class */
      std::string GetName() const { return std::string ("GradientImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, bool useImageSpacing, bool useImageDirection );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      bool  m_UseImageSpacing;
      bool  m_UseImageDirection;
    };


    /**
     * \brief Computes the gradient of an image using directional derivatives.
     *
     * This function directly calls the execute method of GradientImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::GradientImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Gradient ( const Image& image1, bool useImageSpacing = true, bool useImageDirection = false );

  }
}
#endif
