/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGeodesicActiveContourLevelSetImageFilter_h
#define sitkGeodesicActiveContourLevelSetImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class GeodesicActiveContourLevelSetImageFilter
\brief Segments structures in images based on a user supplied edge potential map.

\par IMPORTANT
The SegmentationLevelSetImageFilter class and the GeodesicActiveContourLevelSetFunction class contain additional information necessary to gain full understanding of how to use this filter.

\par OVERVIEW
This class is a level set method segmentation filter. An initial contour is propagated outwards (or inwards) until it ''sticks'' to the shape boundaries. This is done by using a level set speed function based on a user supplied edge potential map.

\par INPUTS
This filter requires two inputs. The first input is a initial level set. The initial level set is a real image which contains the initial contour/surface as the zero level set. For example, a signed distance function from the initial contour/surface is typically used. Unlike the simpler ShapeDetectionLevelSetImageFilter the initial contour does not have to lie wholly within the shape to be segmented. The initial contour is allow to overlap the shape boundary. The extra advection term in the update equation behaves like a doublet and attracts the contour to the boundary. This approach for segmentation follows that of Caselles et al (1997).

\par 
The second input is the feature image. For this filter, this is the edge potential map. General characteristics of an edge potential map is that it has values close to zero in regions near the edges and values close to one inside the shape itself. Typically, the edge potential map is compute from the image gradient, for example:

 \f[ g(I) = 1 / ( 1 + | (\nabla * G)(I)| ) \f] \f[ g(I) = \exp^{-|(\nabla * G)(I)|} \f] 

where \f$ I \f$ is image intensity and \f$ (\nabla * G) \f$ is the derivative of Gaussian operator.

\par 
See SegmentationLevelSetImageFilter and SparseFieldLevelSetImageFilter for more information on Inputs.

\par PARAMETERS
The PropagationScaling parameter can be used to switch from propagation outwards (POSITIVE scaling parameter) versus propagating inwards (NEGATIVE scaling parameter).

This implementation allows the user to set the weights between the propagation, advection and curvature term using methods SetPropagationScaling() , SetAdvectionScaling() , SetCurvatureScaling() . In general, the larger the CurvatureScaling, the smoother the resulting contour. To follow the implementation in Caselles et al paper, set the PropagationScaling to \f$ c \f$ (the inflation or ballon force) and AdvectionScaling and CurvatureScaling both to 1.0.

\par OUTPUTS
The filter outputs a single, scalar, real-valued image. Negative values in the output image represent the inside of the segmented region and positive values in the image represent the outside of the segmented region. The zero crossings of the image correspond to the position of the propagating front.

\par 
See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.

\par REFERENCES


\par 
"Geodesic Active Contours", V. Caselles, R. Kimmel and G. Sapiro. International Journal on Computer Vision, Vol 22, No. 1, pp 61-97, 1997

\see SegmentationLevelSetImageFilter 

\see GeodesicActiveContourLevelSetFunction 

\see SparseFieldLevelSetImageFilter
\sa itk::simple::GeodesicActiveContourLevelSet for the procedural interface
\sa itk::GeodesicActiveContourLevelSetImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GeodesicActiveContourLevelSetImageFilter : public ImageFilter<2> {
    public:
      typedef GeodesicActiveContourLevelSetImageFilter Self;

      /** Destructor */
      virtual ~GeodesicActiveContourLevelSetImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GeodesicActiveContourLevelSetImageFilter();

      /** Define the pixels types supported by this filter */
      typedef RealPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaximumRMSError ( double MaximumRMSError ) { this->m_MaximumRMSError = MaximumRMSError; return *this; }

      /**
       */
        double GetMaximumRMSError() const { return this->m_MaximumRMSError; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetPropagationScaling ( double PropagationScaling ) { this->m_PropagationScaling = PropagationScaling; return *this; }

      /**
       */
        double GetPropagationScaling() const { return this->m_PropagationScaling; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetCurvatureScaling ( double CurvatureScaling ) { this->m_CurvatureScaling = CurvatureScaling; return *this; }

      /**
       */
        double GetCurvatureScaling() const { return this->m_CurvatureScaling; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAdvectionScaling ( double AdvectionScaling ) { this->m_AdvectionScaling = AdvectionScaling; return *this; }

      /**
       */
        double GetAdvectionScaling() const { return this->m_AdvectionScaling; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNumberOfIterations ( uint32_t NumberOfIterations ) { this->m_NumberOfIterations = NumberOfIterations; return *this; }

      /**
       */
        uint32_t GetNumberOfIterations() const { return this->m_NumberOfIterations; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReverseExpansionDirection ( bool ReverseExpansionDirection ) { this->m_ReverseExpansionDirection = ReverseExpansionDirection; return *this; }

      /** Set the value of ReverseExpansionDirection to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER ReverseExpansionDirectionOn() { return this->SetReverseExpansionDirection(true); }
      SITK_RETURN_SELF_TYPE_HEADER ReverseExpansionDirectionOff() { return this->SetReverseExpansionDirection(false); }

      /**
       */
        bool GetReverseExpansionDirection() const { return this->m_ReverseExpansionDirection; }
     /** \brief Number of iterations run.
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     uint32_t GetElapsedIterations() const { return this->m_ElapsedIterations; };

     /** \brief The Root Mean Square of the levelset upon termination.
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetRMSChange() const { return this->m_RMSChange; };

      /** Name of this class */
      std::string GetName() const { return std::string ("GeodesicActiveContourLevelSetImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter on the input images with the given parameters */
      Image Execute ( const Image& image1, const Image& image2, double maximumRMSError, double propagationScaling, double curvatureScaling, double advectionScaling, uint32_t numberOfIterations, bool reverseExpansionDirection );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Value of RMS change below which the filter should stop. This is a convergence criterion. */
      double  m_MaximumRMSError;
      /* Weight of direct propagation contribution to the speed term */
      double  m_PropagationScaling;
      /* Weight of the curvature contribution to the speed term */
      double  m_CurvatureScaling;
      /* Weight of the advection contribution to the speed term */
      double  m_AdvectionScaling;
      /* Number of iterations to run */
      uint32_t  m_NumberOfIterations;
      /* Turn On/Off the flag which determines whether Positive or Negative speed terms will cause surface expansion.  If set to TRUE then negative speed terms will cause the surface to expand and positive speed terms will cause the surface to contract.  If set to FALSE (default) then positive speed terms will cause the surface to expand and negative speed terms will cause the surface to contract.  This method can be safely used to reverse the expansion/contraction as appropriate to a particular application or data set. */
      bool  m_ReverseExpansionDirection;
      /* Level Set filter that uses propagation, curvature and advection terms. */
      uint32_t m_ElapsedIterations;
      /* Level Set filter that uses propagation, curvature and advection terms. */
      double m_RMSChange;

    };


    /**
     * \brief Segments structures in images based on a user supplied edge potential map.
     *
     * This function directly calls the execute method of GeodesicActiveContourLevelSetImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::GeodesicActiveContourLevelSetImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image GeodesicActiveContourLevelSet ( const Image& image1, const Image& image2, double maximumRMSError = 0.01, double propagationScaling = 1.0, double curvatureScaling = 1.0, double advectionScaling = 1.0, uint32_t numberOfIterations = 1000u, bool reverseExpansionDirection = false );

  }
}
#endif
