/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkFlipImageFilter_h
#define sitkFlipImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class FlipImageFilter
\brief Flips an image across user specified axes.

FlipImageFilter flips an image across user specified axes. The flip axes are set via method SetFlipAxes( array ) where the input is a FixedArray<bool,ImageDimension>. The image is flipped across axes for which array[i] is true.

In terms of grid coordinates the image is flipped within the LargestPossibleRegion of the input image. As such, the LargestPossibleRegion of the output image is the same as the input.

In terms of geometric coordinates, the output origin is such that the image is flipped with respect to the coordinate axes.
\sa itk::simple::Flip for the procedural interface
\sa itk::FlipImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT FlipImageFilter : public ImageFilter<1> {
    public:
      typedef FlipImageFilter Self;

      /** Destructor */
      virtual ~FlipImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      FlipImageFilter();

      /** Define the pixels types supported by this filter */
      typedef NonLabelPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get the axis to be flipped. The image is flipped along axes for which array[i] is true. Default is false.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFlipAxes ( const std::vector<bool> & FlipAxes ) { this->m_FlipAxes = FlipAxes; return *this; }

      /**
       * Set/Get the axis to be flipped. The image is flipped along axes for which array[i] is true. Default is false.
       */
        std::vector<bool> GetFlipAxes() const { return this->m_FlipAxes; }

      /**
       * Controls how the output origin is computed. If FlipAboutOrigin is "On", the flip will occur about the origin of the axis, otherwise, the flip will occur about the center of the axis. Default is "On".
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFlipAboutOrigin ( bool FlipAboutOrigin ) { this->m_FlipAboutOrigin = FlipAboutOrigin; return *this; }

      /** Set the value of FlipAboutOrigin to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FlipAboutOriginOn() { return this->SetFlipAboutOrigin(true); }
      SITK_RETURN_SELF_TYPE_HEADER FlipAboutOriginOff() { return this->SetFlipAboutOrigin(false); }

      /**
       * Controls how the output origin is computed. If FlipAboutOrigin is "On", the flip will occur about the origin of the axis, otherwise, the flip will occur about the center of the axis. Default is "On".
       */
        bool GetFlipAboutOrigin() const { return this->m_FlipAboutOrigin; }
      /** Name of this class */
      std::string GetName() const { return std::string ("FlipImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector<bool> & flipAxes, bool flipAboutOrigin );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<bool>  m_FlipAxes;
      /*  */
      bool  m_FlipAboutOrigin;
    };


    /**
     * \brief Flips an image across user specified axes.
     *
     * This function directly calls the execute method of FlipImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::FlipImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Flip ( const Image& image1, const std::vector<bool> & flipAxes = std::vector<bool>(3, false), bool flipAboutOrigin = false );

  }
}
#endif
