/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkFFTConvolutionImageFilter_h
#define sitkFFTConvolutionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class FFTConvolutionImageFilter
\brief Convolve a given image with an arbitrary image kernel using multiplication in the Fourier domain.

This filter produces output equivalent to the output of the ConvolutionImageFilter . However, it takes advantage of the convolution theorem to accelerate the convolution computation when the kernel is large.

\warning This filter ignores the spacing, origin, and orientation of the kernel image and treats them as identical to those in the input image.

This code was adapted from the Insight Journal contribution:

"FFT Based Convolution" by Gaetan Lehmann https://hdl.handle.net/10380/3154 

\see ConvolutionImageFilter
\sa itk::simple::FFTConvolution for the procedural interface
\sa itk::FFTConvolutionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT FFTConvolutionImageFilter : public ImageFilter<0> {
    public:
      typedef FFTConvolutionImageFilter Self;

      /** Destructor */
      virtual ~FFTConvolutionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      FFTConvolutionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Normalize the output image by the sum of the kernel components

       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalize ( bool Normalize ) { this->m_Normalize = Normalize; return *this; }

      /** Set the value of Normalize to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOn() { return this->SetNormalize(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOff() { return this->SetNormalize(false); }

      /**
       */
        bool GetNormalize() const { return this->m_Normalize; }

      typedef enum {ZERO_PAD,ZERO_FLUX_NEUMANN_PAD,PERIODIC_PAD} BoundaryConditionType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBoundaryCondition ( BoundaryConditionType BoundaryCondition ) { this->m_BoundaryCondition = BoundaryCondition; return *this; }

      /**
       */
        BoundaryConditionType GetBoundaryCondition() const { return this->m_BoundaryCondition; }

      typedef enum {SAME,VALID} OutputRegionModeType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputRegionMode ( OutputRegionModeType OutputRegionMode ) { this->m_OutputRegionMode = OutputRegionMode; return *this; }

      /**
       */
        OutputRegionModeType GetOutputRegionMode() const { return this->m_OutputRegionMode; }
      /** Name of this class */
      std::string GetName() const { return std::string ("FFTConvolutionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image & image, const Image & kernelImage );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image & image, const Image & kernelImage, bool normalize, FFTConvolutionImageFilter::BoundaryConditionType boundaryCondition, FFTConvolutionImageFilter::OutputRegionModeType outputRegionMode );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image * image, const Image * kernelImage );
      template <class TImageType> Image ExecuteInternal ( const Image * image, const Image * kernelImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_Normalize;
      BoundaryConditionType  m_BoundaryCondition;
      OutputRegionModeType  m_OutputRegionMode;
    };


    /**
     * \brief Convolve a given image with an arbitrary image kernel using multiplication in the Fourier domain.
     *
     * This function directly calls the execute method of FFTConvolutionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::FFTConvolutionImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image FFTConvolution ( const Image & image, const Image & kernelImage, bool normalize = false, FFTConvolutionImageFilter::BoundaryConditionType boundaryCondition = itk::simple::FFTConvolutionImageFilter::ZERO_FLUX_NEUMANN_PAD, FFTConvolutionImageFilter::OutputRegionModeType outputRegionMode = itk::simple::FFTConvolutionImageFilter::SAME );

  }
}
#endif
