/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkExpandImageFilter_h
#define sitkExpandImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ExpandImageFilter
\brief Expand the size of an image by an integer factor in each dimension.

ExpandImageFilter increases the size of an image by an integer factor in each dimension using a interpolation method. The output image size in each dimension is given by:

OutputSize[j] = InputSize[j] * ExpandFactors[j]

The output values are obtained by interpolating the input image. The default interpolation type used is the LinearInterpolateImageFunction . The user can specify a particular interpolation function via SetInterpolator() . Note that the input interpolator must derive from base class InterpolateImageFunction .

This filter will produce an output with different pixel spacing that its input image such that:

OutputSpacing[j] = InputSpacing[j] / ExpandFactors[j]

The filter is templated over the input image type and the output image type.

This filter is implemented as a multithreaded filter and supports streaming.

\warning This filter only works for image with scalar pixel types. For vector images use VectorExpandImageFilter .

This filter assumes that the input and output image has the same number of dimensions.

\see InterpolateImageFunction 

\see LinearInterpolationImageFunction 

\see VectorExpandImageFilter
\sa itk::simple::Expand for the procedural interface
\sa itk::ExpandImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ExpandImageFilter : public ImageFilter<1> {
    public:
      typedef ExpandImageFilter Self;

      /** Destructor */
      virtual ~ExpandImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ExpandImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;
      /** Custom public declarations */
      SITK_RETURN_SELF_TYPE_HEADER SetExpandFactor( unsigned int e ) { this->m_ExpandFactors = std::vector<unsigned int>(3, e ); return *this; }



      /**
       * Set the expand factors. Values are clamped to a minimum value of 1. Default is 1 for all dimensions.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetExpandFactors ( const std::vector<unsigned int> & ExpandFactors ) { this->m_ExpandFactors = ExpandFactors; return *this; }

      /** Set the values of the ExpandFactors vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetExpandFactors( unsigned int value ) { this->m_ExpandFactors = std::vector<unsigned int>(3, value); return *this; }


      /**
       * Get the expand factors.
       */
        std::vector<unsigned int> GetExpandFactors() const { return this->m_ExpandFactors; }

      /**
       * Get/Set the interpolator function.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetInterpolator ( InterpolatorEnum Interpolator ) { this->m_Interpolator = Interpolator; return *this; }

      /**
       * Get/Set the interpolator function.
       */
        InterpolatorEnum GetInterpolator() const { return this->m_Interpolator; }
      /** Name of this class */
      std::string GetName() const { return std::string ("ExpandImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector<unsigned int> & expandFactors, InterpolatorEnum interpolator );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInteral on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_ExpandFactors;
      /*  */
      InterpolatorEnum  m_Interpolator;
    };


    /**
     * \brief Expand the size of an image by an integer factor in each dimension.
     *
     * This function directly calls the execute method of ExpandImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ExpandImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Expand ( const Image& image1, const std::vector<unsigned int> & expandFactors = std::vector<unsigned int>(3, 1), InterpolatorEnum interpolator = itk::simple::sitkLinear );

  }
}
#endif
