/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkDilateObjectMorphologyImageFilter_h
#define sitkDilateObjectMorphologyImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkKernelImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkBasicFilters.h"
#include "sitkKernel.h"

namespace itk {
  namespace simple {

    /**\class DilateObjectMorphologyImageFilter
\brief dilation of an object in an image

Dilate an image using binary morphology. Pixel values matching the object value are considered the "foreground" and all other pixels are "background". This is useful in processing mask images containing only one object.

If a pixel's value is equal to the object value and the pixel is adjacent to a non-object valued pixel, then the kernel is centered on the object-value pixel and neighboring pixels covered by the kernel are assigned the object value. The structuring element is assumed to be composed of binary values (zero or one).

\see ObjectMorphologyImageFilter , ErodeObjectMorphologyImageFilter 

\see BinaryDilateImageFilter
\sa itk::simple::DilateObjectMorphology for the procedural interface
\sa itk::DilateObjectMorphologyImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT DilateObjectMorphologyImageFilter : public ImageFilter<1> {
    public:
      typedef DilateObjectMorphologyImageFilter Self;

      /** Destructor */
      virtual ~DilateObjectMorphologyImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      DilateObjectMorphologyImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;

    /** Kernel type enumeration */
    typedef enum{Annulus=sitkAnnulus, Ball=sitkBall, Box=sitkBox, Cross=sitkCross} KernelType;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetObjectValue ( double ObjectValue ) { this->m_ObjectValue = ObjectValue; return *this; }

      /**
       */
        double GetObjectValue() const { return this->m_ObjectValue; }
      /** Kernel radius as a scale for isotropic structures */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(uint32_t r);

      /** Set/Get the radius of the kernel structuring element as a
       * vector.
       *
       * If the dimension of the image is greater then the length of
       * r, then the radius will be padded. If it is less the r will
       * be truncated.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(const std::vector<uint32_t>  &r );
      std::vector<uint32_t> GetKernelRadius() const;

      /** Set/Get the kernel or structuring elemenent used for the
       * morphology */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelEnum t);
#ifndef SWIG
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelType t);
#endif
      KernelEnum GetKernelType() const;

      /** Name of this class */
      std::string GetName() const { return std::string ("DilateObjectMorphologyImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double objectValue );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Value to assign to object pixels */
      double  m_ObjectValue;

      /* Kernel Radius as a vector */
      std::vector<uint32_t> m_KernelRadius;

      /** KernelType */
      KernelEnum m_KernelType;
    };


    /**
     * itk::simple::DilateObjectMorphologyImageFilter Functional Interface
     *
     * This function directly calls the execute method of DilateObjectMorphologyImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT DilateObjectMorphology ( const Image&,
                                          uint32_t radius = 1, KernelEnum kernel = sitkBall
                                          , double objectValue = 1 );


   /**
     * itk::simple::DilateObjectMorphologyImageFilter Functional Interface
     *
     * This function directly calls the execute method of DilateObjectMorphologyImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT DilateObjectMorphology ( const Image&,
                                          const std::vector<uint32_t> vectorRadius, KernelEnum kernel = sitkBall
                                          , double objectValue = 1 );
  }
}
#endif
