/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkDerivativeImageFilter_h
#define sitkDerivativeImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class DerivativeImageFilter
\brief Computes the directional derivative of an image. The directional derivative at each pixel location is computed by convolution with a derivative operator of user-specified order.

SetOrder specifies the order of the derivative.

SetDirection specifies the direction of the derivative with respect to the coordinate axes of the image.

\see Image 

\see Neighborhood 

\see NeighborhoodOperator 

\see NeighborhoodIterator
\sa itk::simple::Derivative for the procedural interface
\sa itk::DerivativeImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT DerivativeImageFilter : public ImageFilter<1> {
    public:
      typedef DerivativeImageFilter Self;

      /** Destructor */
      virtual ~DerivativeImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      DerivativeImageFilter();

      /** Define the pixels types supported by this filter */
      typedef RealPixelIDTypeList  PixelIDTypeList;



      /**
       * The output pixel type must be signed. Standard get/set macros for filter parameters.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDirection ( unsigned int Direction ) { this->m_Direction = Direction; return *this; }

      /**
       * The output pixel type must be signed. Standard get/set macros for filter parameters.
       */
        unsigned int GetDirection() const { return this->m_Direction; }

      /**
       * The output pixel type must be signed. Standard get/set macros for filter parameters.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOrder ( unsigned int Order ) { this->m_Order = Order; return *this; }

      /**
       * The output pixel type must be signed. Standard get/set macros for filter parameters.
       */
        unsigned int GetOrder() const { return this->m_Order; }

      /**
       * Set/Get whether or not the filter will use the spacing of the input image in its calculations
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       * Set/Get whether or not the filter will use the spacing of the input image in its calculations
       */
        bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }
      /** Name of this class */
      std::string GetName() const { return std::string ("DerivativeImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, unsigned int direction, unsigned int order, bool useImageSpacing );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInteral on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      unsigned int  m_Direction;
      unsigned int  m_Order;
      bool  m_UseImageSpacing;
    };


    /**
     * \brief Computes the directional derivative of an image. The directional derivative at each pixel location is computed by convolution with a derivative operator of user-specified order.
     *
     * This function directly calls the execute method of DerivativeImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::DerivativeImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Derivative ( const Image& image1, unsigned int direction = 0u, unsigned int order = 1u, bool useImageSpacing = true );

  }
}
#endif
